/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import com.github.benmanes.caffeine.cache.Caffeine;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflRepository;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.DefaultMutableOcflRepository;
import edu.wisc.library.ocfl.core.DefaultOcflRepository;
import edu.wisc.library.ocfl.core.cache.Cache;
import edu.wisc.library.ocfl.core.cache.CaffeineCache;
import edu.wisc.library.ocfl.core.db.ObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.ObjectDetailsDatabaseBuilder;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.UnsupportedExtensionBehavior;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.lock.InMemoryObjectLock;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import edu.wisc.library.ocfl.core.lock.ObjectLockBuilder;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraints;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMappers;
import edu.wisc.library.ocfl.core.storage.CachingOcflStorage;
import edu.wisc.library.ocfl.core.storage.ObjectDetailsDbOcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorageBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class OcflRepositoryBuilder {
    private OcflStorage storage;
    private OcflConfig config = new OcflConfig();
    private OcflExtensionConfig defaultLayoutConfig;
    private Path workDir;
    private boolean verifyStaging = true;
    private ObjectLock objectLock = new InMemoryObjectLock(10L, TimeUnit.SECONDS);
    private Cache<String, Inventory> inventoryCache = new CaffeineCache<String, Inventory>(Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(512L).build());
    private InventoryMapper inventoryMapper = InventoryMapper.defaultMapper();
    private LogicalPathMapper logicalPathMapper = LogicalPathMappers.directMapper();
    private ContentPathConstraintProcessor contentPathConstraintProcessor = ContentPathConstraints.minimal();
    private ObjectDetailsDatabase objectDetailsDb;
    private UnsupportedExtensionBehavior unsupportedBehavior = UnsupportedExtensionBehavior.FAIL;
    private Set<String> ignoreUnsupportedExtensions = Collections.emptySet();

    public OcflRepositoryBuilder storage(OcflStorage storage) {
        this.storage = (OcflStorage)Enforce.notNull((Object)storage, (String)"storage cannot be null");
        return this;
    }

    public OcflRepositoryBuilder storage(Consumer<OcflStorageBuilder> configureStorage) {
        OcflStorageBuilder builder = OcflStorageBuilder.builder();
        configureStorage.accept(builder);
        this.storage = builder.build();
        return this;
    }

    public OcflRepositoryBuilder workDir(Path workDir) {
        this.workDir = (Path)Enforce.notNull((Object)workDir, (String)"workDir cannot be null");
        return this;
    }

    public OcflRepositoryBuilder objectLock(ObjectLock objectLock) {
        this.objectLock = (ObjectLock)Enforce.notNull((Object)objectLock, (String)"objectLock cannot be null");
        return this;
    }

    public OcflRepositoryBuilder objectLock(Consumer<ObjectLockBuilder> configureLock) {
        ObjectLockBuilder builder = new ObjectLockBuilder();
        configureLock.accept(builder);
        this.objectLock = builder.build();
        return this;
    }

    public OcflRepositoryBuilder inventoryCache(Cache<String, Inventory> inventoryCache) {
        this.inventoryCache = inventoryCache;
        return this;
    }

    public OcflRepositoryBuilder objectDetailsDb(ObjectDetailsDatabase objectDetailsDb) {
        this.objectDetailsDb = objectDetailsDb;
        return this;
    }

    public OcflRepositoryBuilder objectDetailsDb(Consumer<ObjectDetailsDatabaseBuilder> configureDb) {
        ObjectDetailsDatabaseBuilder builder = new ObjectDetailsDatabaseBuilder();
        configureDb.accept(builder);
        this.objectDetailsDb = builder.build();
        return this;
    }

    public OcflRepositoryBuilder prettyPrintJson() {
        return this.inventoryMapper(InventoryMapper.prettyPrintMapper());
    }

    public OcflRepositoryBuilder inventoryMapper(InventoryMapper inventoryMapper) {
        this.inventoryMapper = (InventoryMapper)Enforce.notNull((Object)inventoryMapper, (String)"inventoryMapper cannot be null");
        return this;
    }

    public OcflRepositoryBuilder logicalPathMapper(LogicalPathMapper logicalPathMapper) {
        this.logicalPathMapper = (LogicalPathMapper)Enforce.notNull((Object)logicalPathMapper, (String)"logicalPathMapper cannot be null");
        return this;
    }

    public OcflRepositoryBuilder contentPathConstraints(ContentPathConstraintProcessor contentPathConstraints) {
        this.contentPathConstraintProcessor = (ContentPathConstraintProcessor)Enforce.notNull((Object)contentPathConstraints, (String)"contentPathConstraints cannot be null");
        return this;
    }

    public OcflRepositoryBuilder ocflConfig(OcflConfig config) {
        this.config = (OcflConfig)Enforce.notNull((Object)config, (String)"config cannot be null");
        return this;
    }

    public OcflRepositoryBuilder ocflConfig(Consumer<OcflConfig> configureConfig) {
        this.config = new OcflConfig();
        configureConfig.accept(this.config);
        return this;
    }

    public OcflRepositoryBuilder defaultLayoutConfig(OcflExtensionConfig defaultLayoutConfig) {
        this.defaultLayoutConfig = (OcflExtensionConfig)Enforce.notNull((Object)defaultLayoutConfig, (String)"defaultLayoutConfig cannot be null");
        return this;
    }

    public OcflRepositoryBuilder unsupportedExtensionBehavior(UnsupportedExtensionBehavior unsupportedBehavior) {
        this.unsupportedBehavior = (UnsupportedExtensionBehavior)((Object)Enforce.notNull((Object)((Object)unsupportedBehavior), (String)"unsupportedExtensionBehavior cannot be null"));
        return this;
    }

    public OcflRepositoryBuilder ignoreUnsupportedExtensions(Set<String> ignoreUnsupportedExtensions) {
        this.ignoreUnsupportedExtensions = (Set)Enforce.notNull(ignoreUnsupportedExtensions, (String)"ignoreUnsupportedExtensions cannot be null");
        return this;
    }

    public OcflRepositoryBuilder verifyStaging(boolean verifyStaging) {
        this.verifyStaging = verifyStaging;
        return this;
    }

    public OcflRepository build() {
        return this.buildInternal(DefaultOcflRepository.class);
    }

    public MutableOcflRepository buildMutable() {
        return this.buildInternal(DefaultMutableOcflRepository.class);
    }

    private <T extends OcflRepository> T buildInternal(Class<T> clazz) {
        Enforce.notNull((Object)this.storage, (String)"storage cannot be null");
        Enforce.notNull((Object)this.workDir, (String)"workDir cannot be null");
        ExtensionSupportEvaluator supportEvaluator = new ExtensionSupportEvaluator(this.unsupportedBehavior, this.ignoreUnsupportedExtensions);
        OcflStorage wrappedStorage = this.cache(this.db(this.storage));
        wrappedStorage.initializeStorage(this.config.getOcflVersion(), this.defaultLayoutConfig, this.inventoryMapper, supportEvaluator);
        Enforce.expressionTrue((boolean)Files.exists(this.workDir, new LinkOption[0]), (Object)this.workDir, (String)"workDir must exist");
        Enforce.expressionTrue((boolean)Files.isDirectory(this.workDir, new LinkOption[0]), (Object)this.workDir, (String)"workDir must be a directory");
        if (MutableOcflRepository.class.isAssignableFrom(clazz)) {
            return (T)((OcflRepository)clazz.cast(new DefaultMutableOcflRepository(wrappedStorage, this.workDir, this.objectLock, this.inventoryMapper, this.logicalPathMapper, this.contentPathConstraintProcessor, this.config, this.verifyStaging)));
        }
        return (T)((OcflRepository)clazz.cast(new DefaultOcflRepository(wrappedStorage, this.workDir, this.objectLock, this.inventoryMapper, this.logicalPathMapper, this.contentPathConstraintProcessor, this.config, this.verifyStaging)));
    }

    private OcflStorage cache(OcflStorage storage) {
        if (this.inventoryCache != null) {
            return new CachingOcflStorage(this.inventoryCache, storage);
        }
        return storage;
    }

    private OcflStorage db(OcflStorage storage) {
        if (this.objectDetailsDb != null) {
            return new ObjectDetailsDbOcflStorage(this.objectDetailsDb, storage);
        }
        return storage;
    }
}

