/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import java.util.Objects;

public class HashedNTupleIdEncapsulationLayoutConfig
implements OcflExtensionConfig {
    private static final DigestAlgorithm DEFAULT_DIGEST_ALGORITHM = DigestAlgorithm.sha256;
    private static final int DEFAULT_TUPLE_SIZE = 3;
    private static final int DEFAULT_NUM_TUPLES = 3;
    private DigestAlgorithm digestAlgorithm = DEFAULT_DIGEST_ALGORITHM;
    private int tupleSize = 3;
    private int numberOfTuples = 3;

    @Override
    public String getExtensionName() {
        return "0003-hash-and-id-n-tuple-storage-layout";
    }

    public void setExtensionName(String extensionName) {
        if (!Objects.equals(this.getExtensionName(), extensionName)) {
            throw new OcflExtensionException(String.format("The extension name for %s must be %s; found %s.", this.getClass().getSimpleName(), this.getExtensionName(), extensionName));
        }
    }

    @Override
    @JsonIgnore
    public boolean hasParameters() {
        return true;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public HashedNTupleIdEncapsulationLayoutConfig setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm == null ? DEFAULT_DIGEST_ALGORITHM : digestAlgorithm;
        return this;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public HashedNTupleIdEncapsulationLayoutConfig setTupleSize(Integer tupleSize) {
        this.tupleSize = tupleSize == null ? 3 : (Integer)Enforce.expressionTrue((tupleSize >= 0 && tupleSize <= 32 ? 1 : 0) != 0, (Object)tupleSize, (String)"tupleSize must be between 0 and 32 inclusive");
        return this;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public HashedNTupleIdEncapsulationLayoutConfig setNumberOfTuples(Integer numberOfTuples) {
        this.numberOfTuples = numberOfTuples == null ? 3 : (Integer)Enforce.expressionTrue((numberOfTuples >= 0 && numberOfTuples <= 32 ? 1 : 0) != 0, (Object)numberOfTuples, (String)"numberOfTuples must be between 0 and 32 inclusive");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedNTupleIdEncapsulationLayoutConfig that = (HashedNTupleIdEncapsulationLayoutConfig)o;
        return this.tupleSize == that.tupleSize && this.numberOfTuples == that.numberOfTuples && this.digestAlgorithm.equals((Object)that.digestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.digestAlgorithm, this.tupleSize, this.numberOfTuples);
    }

    public String toString() {
        return "HashedNTupleIdEncapsulationLayoutConfig{digestAlgorithm=" + this.digestAlgorithm.getOcflName() + ", tupleSize=" + this.tupleSize + ", numberOfTuples=" + this.numberOfTuples + "}";
    }
}

