/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import at.favre.lib.bytes.Bytes;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraints;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.util.Collection;

public class InventoryMapper {
    private final ObjectMapper objectMapper;
    private final ContentPathConstraintProcessor contentPathConstraints;

    public static InventoryMapper prettyPrintMapper() {
        return new InventoryMapper(ObjectMappers.prettyPrintMapper());
    }

    public static InventoryMapper defaultMapper() {
        return new InventoryMapper(ObjectMappers.defaultMapper());
    }

    public InventoryMapper(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Enforce.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        this.contentPathConstraints = ContentPathConstraints.minimal();
    }

    public void write(Path destination, Inventory inventory) {
        try {
            this.objectMapper.writeValue(destination.toFile(), (Object)inventory);
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    public void write(OutputStream outputStream, Inventory inventory) {
        try {
            this.objectMapper.writeValue(outputStream, (Object)inventory);
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    public Inventory read(String objectRootPath, DigestAlgorithm digestAlgorithm, Path path) {
        return this.readInternal(false, null, objectRootPath, digestAlgorithm, path);
    }

    public Inventory read(String objectRootPath, DigestAlgorithm digestAlgorithm, InputStream inputStream) {
        return this.readInternal(false, null, objectRootPath, digestAlgorithm, inputStream);
    }

    public Inventory readMutableHead(String objectRootPath, RevisionNum revisionNum, DigestAlgorithm digestAlgorithm, Path path) {
        return this.readInternal(true, revisionNum, objectRootPath, digestAlgorithm, path);
    }

    public Inventory readMutableHead(String objectRootPath, RevisionNum revisionNum, DigestAlgorithm digestAlgorithm, InputStream inputStream) {
        return this.readInternal(true, revisionNum, objectRootPath, digestAlgorithm, inputStream);
    }

    public Inventory readNoDigest(String objectRootPath, Path path) {
        return this.readInternal(false, null, objectRootPath, null, path);
    }

    public Inventory readNoDigest(String objectRootPath, InputStream inputStream) {
        return this.readInternal(false, null, objectRootPath, null, inputStream);
    }

    public Inventory readMutableHeadNoDigest(String objectRootPath, RevisionNum revisionNum, Path path) {
        return this.readInternal(true, revisionNum, objectRootPath, null, path);
    }

    public Inventory readMutableHeadNoDigest(String objectRootPath, RevisionNum revisionNum, InputStream inputStream) {
        return this.readInternal(true, revisionNum, objectRootPath, null, inputStream);
    }

    private Inventory readInternal(boolean mutableHead, RevisionNum revisionNum, String objectRootPath, DigestAlgorithm digestAlgorithm, Path path) {
        return this.readInternal(mutableHead, revisionNum, objectRootPath, this.readBytes(path, digestAlgorithm));
    }

    private Inventory readInternal(boolean mutableHead, RevisionNum revisionNum, String objectRootPath, DigestAlgorithm digestAlgorithm, InputStream inputStream) {
        return this.readInternal(mutableHead, revisionNum, objectRootPath, this.readBytes(inputStream, digestAlgorithm));
    }

    private Inventory readInternal(boolean mutableHead, RevisionNum revisionNum, String objectRootPath, ReadResult readResult) {
        try {
            Inventory inventory = (Inventory)this.objectMapper.reader((InjectableValues)new InjectableValues.Std().addValue("revisionNum", (Object)revisionNum).addValue("mutableHead", (Object)mutableHead).addValue("objectRootPath", (Object)objectRootPath).addValue("inventoryDigest", (Object)readResult.digest)).forType(Inventory.class).readValue(readResult.bytes);
            inventory.getManifest().values().stream().flatMap(Collection::stream).forEach(this.contentPathConstraints::apply);
            return inventory;
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    private ReadResult readBytes(Path path, DigestAlgorithm digestAlgorithm) {
        ReadResult readResult;
        block9: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                readResult = this.readBytes(stream, digestAlgorithm);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new CorruptObjectException(String.format("Inventory missing at: %s", path), (Throwable)e);
                }
                catch (IOException e) {
                    throw new OcflIOException((Exception)e);
                }
            }
            stream.close();
        }
        return readResult;
    }

    private ReadResult readBytes(InputStream stream, DigestAlgorithm digestAlgorithm) {
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        try {
            byte[] bytes;
            String digest = null;
            if (digestAlgorithm != null) {
                DigestInputStream wrapped = new DigestInputStream(bufferedStream, digestAlgorithm.getMessageDigest());
                bytes = wrapped.readAllBytes();
                digest = Bytes.wrap((byte[])wrapped.getMessageDigest().digest()).encodeHex();
            } else {
                bytes = bufferedStream.readAllBytes();
            }
            return new ReadResult(bytes, digest);
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    private static class ReadResult {
        final byte[] bytes;
        final String digest;

        public ReadResult(byte[] bytes, String digest) {
            this.bytes = bytes;
            this.digest = digest;
        }
    }
}

