/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path;

import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraints;
import edu.wisc.library.ocfl.core.path.mapper.DirectLogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.util.FileUtil;

public class ContentPathMapper {
    private final String objectRootPath;
    private final String contentDirectory;
    private final VersionNum versionNum;
    private final RevisionNum revisionNum;
    private final LogicalPathMapper logicalPathMapper;
    private final ContentPathConstraintProcessor contentPathConstraintProcessor;

    public static Builder builder() {
        return new Builder();
    }

    public ContentPathMapper(LogicalPathMapper logicalPathMapper, ContentPathConstraintProcessor contentPathConstraintProcessor, String objectRootPath, String contentDirectory, VersionNum versionNum, RevisionNum revisionNum) {
        this.logicalPathMapper = (LogicalPathMapper)Enforce.notNull((Object)logicalPathMapper, (String)"logicalPathMapper cannot be null");
        this.contentPathConstraintProcessor = (ContentPathConstraintProcessor)Enforce.notNull((Object)contentPathConstraintProcessor, (String)"contentPathConstraintProcessor cannot be null");
        this.objectRootPath = Enforce.notBlank((String)objectRootPath, (String)"objectRootPath cannot be blank");
        this.contentDirectory = Enforce.notBlank((String)contentDirectory, (String)"contentDirectory cannot be blank");
        this.versionNum = versionNum;
        this.revisionNum = revisionNum;
    }

    public String fromLogicalPath(String logicalPath) {
        String contentPathPart = this.logicalPathMapper.toContentPathPart(logicalPath);
        String contentPath = this.contentPath(contentPathPart);
        String storagePath = FileUtil.pathJoinFailEmpty(this.objectRootPath, contentPath);
        this.contentPathConstraintProcessor.apply(contentPathPart, storagePath);
        return contentPath;
    }

    private String contentPath(String contentPathPart) {
        if (this.isMutableHead()) {
            return FileUtil.pathJoinFailEmpty("extensions/0005-mutable-head/head", this.contentDirectory, this.revisionNum.toString(), contentPathPart);
        }
        return FileUtil.pathJoinFailEmpty(this.versionNum.toString(), this.contentDirectory, contentPathPart);
    }

    private boolean isMutableHead() {
        return this.revisionNum != null;
    }

    public static class Builder {
        private LogicalPathMapper logicalPathMapper = new DirectLogicalPathMapper();
        private ContentPathConstraintProcessor contentPathConstraintProcessor = ContentPathConstraints.minimal();

        public Builder logicalPathMapper(LogicalPathMapper logicalPathMapper) {
            this.logicalPathMapper = (LogicalPathMapper)Enforce.notNull((Object)logicalPathMapper, (String)"logicalPathMapper cannot be null");
            return this;
        }

        public Builder contentPathConstraintProcessor(ContentPathConstraintProcessor contentPathConstraintProcessor) {
            this.contentPathConstraintProcessor = (ContentPathConstraintProcessor)Enforce.notNull((Object)contentPathConstraintProcessor, (String)"contentPathConstraintProcessor cannot be null");
            return this;
        }

        public ContentPathMapper buildStandardVersion(Inventory inventory) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            return new ContentPathMapper(this.logicalPathMapper, this.contentPathConstraintProcessor, inventory.getObjectRootPath(), inventory.resolveContentDirectory(), (VersionNum)Enforce.notNull((Object)inventory.nextVersionNum(), (String)"versionNum cannot be null"), null);
        }

        public ContentPathMapper buildMutableVersion(Inventory inventory) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            return new ContentPathMapper(this.logicalPathMapper, this.contentPathConstraintProcessor, inventory.getObjectRootPath(), inventory.resolveContentDirectory(), null, (RevisionNum)Enforce.notNull((Object)inventory.nextRevisionNum(), (String)"revisionNum cannot be null"));
        }
    }
}

