/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.DefaultOcflObjectUpdater;
import edu.wisc.library.ocfl.core.DefaultOcflRepository;
import edu.wisc.library.ocfl.core.inventory.AddFileProcessor;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.inventory.InventoryUpdater;
import edu.wisc.library.ocfl.core.inventory.MutableHeadInventoryCommitter;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMutableOcflRepository
extends DefaultOcflRepository
implements MutableOcflRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMutableOcflRepository.class);

    public DefaultMutableOcflRepository(OcflStorage storage, Path workDir, ObjectLock objectLock, InventoryMapper inventoryMapper, LogicalPathMapper logicalPathMapper, ContentPathConstraintProcessor contentPathConstraintProcessor, OcflConfig config, boolean verifyStaging) {
        super(storage, workDir, objectLock, inventoryMapper, logicalPathMapper, contentPathConstraintProcessor, config, verifyStaging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVersionId stageChanges(ObjectVersionId objectVersionId, VersionInfo versionInfo, Consumer<OcflObjectUpdater> objectUpdater) {
        this.ensureOpen();
        Enforce.notNull((Object)objectVersionId, (String)"objectVersionId cannot be null");
        Enforce.notNull(objectUpdater, (String)"objectUpdater cannot be null");
        this.validateVersionInfo(versionInfo);
        LOG.debug("Stage changes to object <{}>", (Object)objectVersionId.getObjectId());
        Inventory inventory = this.loadInventory(objectVersionId);
        if (inventory == null) {
            inventory = this.createAndPersistEmptyVersion(objectVersionId);
        }
        this.enforceObjectVersionForUpdate(objectVersionId, inventory);
        Path stagingDir = this.createStagingDir(objectVersionId.getObjectId());
        Path contentDir = UncheckedFiles.createDirectories(this.resolveRevisionDir(inventory, stagingDir)).getParent();
        InventoryUpdater inventoryUpdater = this.inventoryUpdaterBuilder.buildCopyStateMutable(inventory);
        AddFileProcessor addFileProcessor = this.addFileProcessorBuilder.build(inventoryUpdater, contentDir, inventory.getDigestAlgorithm());
        DefaultOcflObjectUpdater updater = new DefaultOcflObjectUpdater(inventory, inventoryUpdater, contentDir, addFileProcessor);
        try {
            objectUpdater.accept(updater);
            Inventory newInventory = this.buildNewInventory(inventoryUpdater, versionInfo);
            this.writeNewVersion(newInventory, stagingDir, false);
            ObjectVersionId objectVersionId2 = ObjectVersionId.version((String)objectVersionId.getObjectId(), (VersionNum)newInventory.getHead());
            return objectVersionId2;
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVersionId commitStagedChanges(String objectId, VersionInfo versionInfo) {
        this.ensureOpen();
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        this.validateVersionInfo(versionInfo);
        LOG.debug("Commit staged changes on object <{}>", (Object)objectId);
        Inventory inventory = this.requireInventory(ObjectVersionId.head((String)objectId));
        if (inventory.hasMutableHead()) {
            Inventory newInventory = MutableHeadInventoryCommitter.commit(inventory, this.now(versionInfo), versionInfo, this.config);
            Path stagingDir = FileUtil.createObjectTempDir(this.workDir, objectId);
            Inventory finalInventory = this.writeInventory(newInventory, stagingDir);
            try {
                this.objectLock.doInWriteLock(inventory.getId(), () -> this.storage.commitMutableHead(inventory, finalInventory, stagingDir));
            }
            finally {
                FileUtil.safeDeleteDirectory(stagingDir);
            }
        }
        return ObjectVersionId.version((String)objectId, (VersionNum)inventory.getHead());
    }

    public void purgeStagedChanges(String objectId) {
        this.ensureOpen();
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        LOG.info("Purge staged changes on object <{}>", (Object)objectId);
        this.objectLock.doInWriteLock(objectId, () -> this.storage.purgeMutableHead(objectId));
    }

    public boolean hasStagedChanges(String objectId) {
        this.ensureOpen();
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        LOG.debug("Check if object <{}> has staged changes", (Object)objectId);
        Inventory inventory = this.loadInventory(ObjectVersionId.head((String)objectId));
        if (inventory != null) {
            return inventory.hasMutableHead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inventory createAndPersistEmptyVersion(ObjectVersionId objectId) {
        LOG.info("Creating object {} with an empty version.", (Object)objectId.getObjectId());
        Inventory stubInventory = this.createStubInventory(objectId);
        Path stagingDir = FileUtil.createObjectTempDir(this.workDir, objectId.getObjectId());
        UncheckedFiles.createDirectories(this.resolveContentDir(stubInventory, stagingDir));
        try {
            Inventory inventory = stubInventory.buildFrom().addHeadVersion(Version.builder().versionInfo(new VersionInfo().setMessage("Auto-generated empty object version.").setUser("ocfl-java", "https://github.com/UW-Madison-Library/ocfl-java")).created(this.now(null)).build()).build();
            this.writeNewVersion(inventory, stagingDir, false);
            Inventory inventory2 = inventory;
            return inventory2;
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    private Path resolveRevisionDir(Inventory inventory, Path parent) {
        Path contentDir = this.resolveContentDir(inventory, parent);
        RevisionNum newRevision = inventory.nextRevisionNum();
        return contentDir.resolve(newRevision.toString());
    }
}

