/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.core.db.BaseObjectDetailsDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class PostgresObjectDetailsDatabase
extends BaseObjectDetailsDatabase {
    private static final String LOCK_FAIL_STATE = "55P03";
    private static final String DUPLICATE_KEY_STATE = "23505";

    public PostgresObjectDetailsDatabase(String tableName, DataSource dataSource, boolean storeInventory, long waitTime, TimeUnit timeUnit) {
        super(tableName, dataSource, storeInventory, waitTime, timeUnit, LOCK_FAIL_STATE);
    }

    @Override
    protected void setLockWaitTimeout(Connection connection, long waitMillis) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("SET LOCAL lock_timeout = %s", waitMillis));){
            statement.executeUpdate();
        }
    }

    @Override
    protected boolean isConcurrentWriteException(SQLException exception) {
        return Objects.equals(exception.getSQLState(), DUPLICATE_KEY_STATE);
    }
}

