/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.exception.OverwriteException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.InventoryBuilder;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.model.VersionBuilder;
import edu.wisc.library.ocfl.core.path.ContentPathMapper;
import edu.wisc.library.ocfl.core.path.constraint.LogicalPathConstraints;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;

public class InventoryUpdater {
    private final Inventory inventory;
    private final String objectId;
    private final boolean mutableHead;
    private final InventoryBuilder inventoryBuilder;
    private final VersionBuilder versionBuilder;
    private final ContentPathMapper contentPathMapper;
    private final PathConstraintProcessor logicalPathConstraints;

    public static Builder builder() {
        return new Builder();
    }

    private InventoryUpdater(Inventory inventory, InventoryBuilder inventoryBuilder, VersionBuilder versionBuilder, ContentPathMapper contentPathMapper) {
        this.inventory = (Inventory)Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        this.inventoryBuilder = (InventoryBuilder)Enforce.notNull((Object)inventoryBuilder, (String)"inventoryBuilder cannot be null");
        this.versionBuilder = (VersionBuilder)Enforce.notNull((Object)versionBuilder, (String)"versionBuilder cannot be null");
        this.contentPathMapper = (ContentPathMapper)Enforce.notNull((Object)contentPathMapper, (String)"contentPathMapper cannot be null");
        this.objectId = inventory.getId();
        this.mutableHead = inventoryBuilder.hasMutableHead();
        this.logicalPathConstraints = LogicalPathConstraints.constraints();
    }

    public Inventory buildNewInventory(OffsetDateTime createdTimestamp, VersionInfo versionInfo) {
        return this.inventoryBuilder.addHeadVersion(this.versionBuilder.versionInfo(versionInfo).created(createdTimestamp).build()).build();
    }

    public boolean upgradeInventory(OcflConfig config) {
        if (config.isUpgradeObjectsOnWrite() && this.inventoryBuilder.getType().compareTo((Enum)config.getOcflVersion().getInventoryType()) < 0) {
            this.inventoryBuilder.type(config.getOcflVersion().getInventoryType());
            return true;
        }
        return false;
    }

    public AddFileResult addFile(String fileId, String logicalPath, OcflOption ... options) {
        this.logicalPathConstraints.apply(logicalPath);
        this.overwriteProtection(logicalPath, options);
        this.versionBuilder.validateNonConflictingPath(logicalPath);
        if (this.versionBuilder.containsLogicalPath(logicalPath)) {
            String oldFileId = this.versionBuilder.removeLogicalPath(logicalPath);
            this.removeFileFromManifest(oldFileId);
        }
        String contentPath = null;
        if (!this.inventoryBuilder.containsFileId(fileId)) {
            contentPath = this.contentPathMapper.fromLogicalPath(logicalPath);
            this.inventoryBuilder.addFileToManifest(fileId, contentPath);
        }
        this.versionBuilder.addFile(fileId, logicalPath);
        return new AddFileResult(contentPath, this.pathUnderContentDir(contentPath));
    }

    public String innerContentPath(String logicalPath) {
        return this.pathUnderContentDir(this.contentPathMapper.fromLogicalPath(logicalPath));
    }

    public void addFixity(String logicalPath, DigestAlgorithm algorithm, String digest) {
        if (algorithm.equals((Object)this.inventory.getDigestAlgorithm())) {
            return;
        }
        String fileId = this.versionBuilder.getFileId(logicalPath);
        if (fileId != null) {
            this.inventoryBuilder.getContentPaths(fileId).forEach(contentPath -> this.inventoryBuilder.addFixityForFile((String)contentPath, algorithm, digest));
        }
    }

    public String getFixityDigest(String logicalPath, DigestAlgorithm algorithm) {
        if (this.inventory.getDigestAlgorithm().equals((Object)algorithm)) {
            return this.versionBuilder.getFileId(logicalPath);
        }
        String digest = null;
        String fileId = this.versionBuilder.getFileId(logicalPath);
        if (fileId != null) {
            digest = this.inventoryBuilder.getFileFixity(fileId, algorithm);
        }
        return digest;
    }

    public void clearFixity() {
        this.inventoryBuilder.clearFixity();
    }

    public Set<RemoveFileResult> removeFile(String logicalPath) {
        String fileId = this.versionBuilder.removeLogicalPath(logicalPath);
        return this.removeFileFromManifestWithResults(fileId);
    }

    public Set<RemoveFileResult> renameFile(String srcLogicalPath, String dstLogicalPath, OcflOption ... options) {
        this.logicalPathConstraints.apply(dstLogicalPath);
        String srcDigest = this.versionBuilder.getFileId(srcLogicalPath);
        if (srcDigest == null) {
            throw new OcflInputException(String.format("The following path was not found in object %s: %s", this.objectId, srcLogicalPath));
        }
        this.overwriteProtection(dstLogicalPath, options);
        this.versionBuilder.validateNonConflictingPath(dstLogicalPath);
        String dstFileId = this.versionBuilder.getFileId(dstLogicalPath);
        this.versionBuilder.removeLogicalPath(srcLogicalPath);
        this.versionBuilder.removeLogicalPath(dstLogicalPath);
        this.versionBuilder.addFile(srcDigest, dstLogicalPath);
        return this.removeFileFromManifestWithResults(dstFileId);
    }

    public Set<RemoveFileResult> reinstateFile(VersionNum sourceVersion, String srcLogicalPath, String dstLogicalPath, OcflOption ... options) {
        this.logicalPathConstraints.apply(dstLogicalPath);
        String srcDigest = this.getDigestFromVersion(sourceVersion, srcLogicalPath);
        if (srcDigest == null) {
            throw new OcflInputException(String.format("Object %s version %s does not contain a file at %s", this.objectId, sourceVersion, srcLogicalPath));
        }
        this.overwriteProtection(dstLogicalPath, options);
        this.versionBuilder.validateNonConflictingPath(dstLogicalPath);
        String dstFileId = this.versionBuilder.getFileId(dstLogicalPath);
        this.versionBuilder.removeLogicalPath(dstLogicalPath);
        this.versionBuilder.addFile(srcDigest, dstLogicalPath);
        return this.removeFileFromManifestWithResults(dstFileId);
    }

    public void clearState() {
        HashSet<String> state = new HashSet<String>(this.versionBuilder.getInvertedState().keySet());
        state.forEach(this::removeFile);
    }

    private String getDigestFromVersion(VersionNum versionNum, String logicalPath) {
        Version version;
        String digest = null;
        if (this.inventory != null && (version = this.inventory.getVersion(versionNum)) != null) {
            digest = version.getFileId(logicalPath);
        }
        return digest;
    }

    private Set<RemoveFileResult> removeFileFromManifestWithResults(String fileId) {
        HashSet<RemoveFileResult> results = new HashSet<RemoveFileResult>();
        if (fileId != null) {
            Set<String> removePaths = this.removeFileFromManifest(fileId);
            removePaths.forEach(removePath -> results.add(new RemoveFileResult((String)removePath, this.pathUnderContentDir((String)removePath))));
        }
        return results;
    }

    private Set<String> removeFileFromManifest(String fileId) {
        if (this.mutableHead) {
            return this.removeFileFromManifest(fileId, "extensions/0005-mutable-head/head");
        }
        return this.removeFileFromManifest(fileId, this.inventory.nextVersionNum().toString() + "/");
    }

    private Set<String> removeFileFromManifest(String fileId, String prefix) {
        Set<String> contentPaths = this.inventoryBuilder.getContentPaths(fileId);
        HashSet<String> removePaths = new HashSet<String>();
        contentPaths.forEach(contentPath -> {
            if (contentPath.startsWith(prefix) && !this.versionBuilder.containsFileId(fileId)) {
                this.inventoryBuilder.removeFileId(fileId);
                removePaths.add((String)contentPath);
            }
        });
        return removePaths;
    }

    private void overwriteProtection(String logicalPath, OcflOption ... options) {
        if (this.versionBuilder.containsLogicalPath(logicalPath) && !OcflOption.contains((OcflOption)OcflOption.OVERWRITE, (OcflOption[])options)) {
            throw new OverwriteException(String.format("There is already a file at %s in object %s. Use OcflOption.OVERWRITE to overwrite it.", logicalPath, this.objectId));
        }
    }

    private String pathUnderContentDir(String contentPath) {
        if (contentPath == null) {
            return null;
        }
        String content = this.inventory.resolveContentDirectory() + "/";
        int startIndex = contentPath.indexOf(content);
        return contentPath.substring(startIndex + content.length());
    }

    public static class RemoveFileResult {
        private final String contentPath;
        private final String pathUnderContentDir;

        private RemoveFileResult(String contentPath, String pathUnderContentDir) {
            this.contentPath = contentPath;
            this.pathUnderContentDir = pathUnderContentDir;
        }

        public String getContentPath() {
            return this.contentPath;
        }

        public String getPathUnderContentDir() {
            return this.pathUnderContentDir;
        }
    }

    public static class AddFileResult {
        private final boolean isNew;
        private final String contentPath;
        private final String pathUnderContentDir;

        private AddFileResult(String contentPath, String pathUnderContentDir) {
            this.isNew = contentPath != null;
            this.contentPath = contentPath;
            this.pathUnderContentDir = pathUnderContentDir;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public String getContentPath() {
            return this.contentPath;
        }

        public String getPathUnderContentDir() {
            return this.pathUnderContentDir;
        }
    }

    public static class Builder {
        private ContentPathMapper.Builder contentPathMapperBuilder = ContentPathMapper.builder();

        public Builder contentPathMapperBuilder(ContentPathMapper.Builder contentPathMapperBuilder) {
            this.contentPathMapperBuilder = (ContentPathMapper.Builder)Enforce.notNull((Object)contentPathMapperBuilder, (String)"contentPathMapperBuilder cannot be null");
            return this;
        }

        public InventoryUpdater buildBlankState(Inventory inventory) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            InventoryBuilder inventoryBuilder = inventory.buildNextVersionFrom();
            VersionBuilder versionBuilder = Version.builder();
            return new InventoryUpdater(inventory, inventoryBuilder, versionBuilder, this.contentPathMapperBuilder.buildStandardVersion(inventory));
        }

        public InventoryUpdater buildCopyState(Inventory inventory) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            InventoryBuilder inventoryBuilder = inventory.buildNextVersionFrom();
            VersionBuilder versionBuilder = inventory.getHeadVersion() != null ? Version.builder(inventory.getHeadVersion()) : Version.builder();
            return new InventoryUpdater(inventory, inventoryBuilder, versionBuilder, this.contentPathMapperBuilder.buildStandardVersion(inventory));
        }

        public InventoryUpdater buildCopyState(Inventory inventory, VersionNum versionNum) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            Enforce.notNull((Object)versionNum, (String)"versionNum cannot be null");
            InventoryBuilder inventoryBuilder = inventory.buildNextVersionFrom();
            VersionBuilder versionBuilder = Version.builder(inventory.getVersion(versionNum));
            return new InventoryUpdater(inventory, inventoryBuilder, versionBuilder, this.contentPathMapperBuilder.buildStandardVersion(inventory));
        }

        public InventoryUpdater buildCopyStateMutable(Inventory inventory) {
            Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
            InventoryBuilder inventoryBuilder = inventory.buildNextVersionFrom().mutableHead(true);
            VersionBuilder versionBuilder = Version.builder(inventory.getHeadVersion());
            return new InventoryUpdater(inventory, inventoryBuilder, versionBuilder, this.contentPathMapperBuilder.buildMutableVersion(inventory));
        }
    }
}

