/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.FileChange;
import edu.wisc.library.ocfl.api.model.FileChangeHistory;
import edu.wisc.library.ocfl.api.model.FileChangeType;
import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.ObjectDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResponseMapper {
    public ObjectDetails mapInventory(Inventory inventory) {
        ObjectDetails details = new ObjectDetails().setId(inventory.getId()).setDigestAlgorithm(inventory.getDigestAlgorithm()).setObjectOcflVersion(inventory.getType().getOcflVersion()).setHeadVersionNum(inventory.getHead());
        Map versionMap = inventory.getVersions().entrySet().stream().map(entry -> this.mapVersion(inventory, (VersionNum)entry.getKey(), (Version)entry.getValue())).collect(Collectors.toMap(VersionDetails::getVersionNum, Function.identity()));
        details.setVersions(versionMap);
        return details;
    }

    public VersionDetails mapVersion(Inventory inventory, VersionNum versionNum, Version version) {
        return new VersionDetails().setObjectVersionId(ObjectVersionId.version((String)inventory.getId(), (VersionNum)versionNum)).setObjectOcflVersion(inventory.getType().getOcflVersion()).setCreated(version.getCreated()).setMutable(inventory.hasMutableHead() && inventory.getHead().equals((Object)versionNum)).setFileMap(this.mapFileDetails(inventory, version)).setVersionInfo(this.versionInfo(version));
    }

    public FileChangeHistory fileChangeHistory(Inventory inventory, String logicalPath) {
        ArrayList<FileChange> changes = new ArrayList<FileChange>();
        String lastFileId = null;
        for (Map.Entry<VersionNum, Version> entry : inventory.getVersions().entrySet()) {
            VersionNum versionNum = entry.getKey();
            Version version = entry.getValue();
            String fileId = version.getFileId(logicalPath);
            if (fileId != null && !Objects.equals(lastFileId, fileId)) {
                lastFileId = fileId;
                String contentPath = inventory.ensureContentPath(fileId);
                Map<DigestAlgorithm, String> fixity = inventory.getFixityForContentPath(contentPath);
                fixity.put(inventory.getDigestAlgorithm(), fileId);
                changes.add(new FileChange().setChangeType(FileChangeType.UPDATE).setObjectVersionId(ObjectVersionId.version((String)inventory.getId(), (VersionNum)versionNum)).setPath(logicalPath).setTimestamp(version.getCreated()).setVersionInfo(this.versionInfo(version)).setStorageRelativePath(inventory.storagePath(fileId)).setFixity(fixity));
                continue;
            }
            if (fileId != null || lastFileId == null) continue;
            lastFileId = null;
            changes.add(new FileChange().setChangeType(FileChangeType.REMOVE).setObjectVersionId(ObjectVersionId.version((String)inventory.getId(), (VersionNum)versionNum)).setPath(logicalPath).setTimestamp(version.getCreated()).setVersionInfo(this.versionInfo(version)).setFixity(Collections.emptyMap()));
        }
        return new FileChangeHistory().setPath(logicalPath).setFileChanges(changes);
    }

    private Map<String, FileDetails> mapFileDetails(Inventory inventory, Version version) {
        HashMap<String, FileDetails> fileDetailsMap = new HashMap<String, FileDetails>();
        DigestAlgorithm digestAlgorithm = inventory.getDigestAlgorithm();
        version.getState().forEach((digest, paths) -> paths.forEach(path -> {
            String contentPath = inventory.getContentPath((String)digest);
            FileDetails details = new FileDetails().setPath(path).setStorageRelativePath(inventory.storagePath((String)digest)).addDigest(digestAlgorithm, digest);
            Map<DigestAlgorithm, String> digests = inventory.getFixityForContentPath(contentPath);
            digests.forEach((arg_0, arg_1) -> ((FileDetails)details).addDigest(arg_0, arg_1));
            fileDetailsMap.put((String)path, details);
        }));
        return fileDetailsMap;
    }

    private VersionInfo versionInfo(Version version) {
        VersionInfo versionInfo = new VersionInfo().setMessage(version.getMessage()).setCreated(version.getCreated());
        if (version.getUser() != null) {
            versionInfo.setUser(version.getUser().getName(), version.getUser().getAddress());
        }
        return versionInfo;
    }
}

