/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.model.ValidationCode;
import edu.wisc.library.ocfl.api.model.ValidationIssue;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ValidationResultsBuilder {
    private final List<ValidationIssue> errors = new ArrayList<ValidationIssue>();
    private final List<ValidationIssue> warnings = new ArrayList<ValidationIssue>();
    private final List<ValidationIssue> infos = new ArrayList<ValidationIssue>();

    public ValidationResults build() {
        return new ValidationResults(this.errors, this.warnings, this.infos);
    }

    public void addAll(ValidationResultsBuilder other) {
        this.errors.addAll(other.errors);
        this.warnings.addAll(other.warnings);
        this.infos.addAll(other.infos);
    }

    public void addAll(ValidationResults other) {
        this.errors.addAll(other.getErrors());
        this.warnings.addAll(other.getWarnings());
        this.infos.addAll(other.getInfos());
    }

    public ValidationResultsBuilder addIssue(ValidationCode code, String messageTemplate, Object ... args) {
        Enforce.notNull((Object)code, (String)"code cannot be null");
        String message = messageTemplate;
        if (args != null && args.length > 0) {
            message = String.format(messageTemplate, args);
        }
        return this.addIssue(Optional.of(new ValidationIssue(code, message)));
    }

    public ValidationResultsBuilder addIssue(Optional<ValidationIssue> issue) {
        issue.ifPresent(i -> {
            switch (i.getCode().getType()) {
                case ERROR: {
                    this.errors.add((ValidationIssue)i);
                    break;
                }
                case WARN: {
                    this.warnings.add((ValidationIssue)i);
                    break;
                }
                case INFO: {
                    this.infos.add((ValidationIssue)i);
                    break;
                }
                default: {
                    throw new OcflJavaException("Unknown validation code type: " + i.getCode().getType());
                }
            }
        });
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean hasInfos() {
        return !this.infos.isEmpty();
    }

    public List<ValidationIssue> getErrors() {
        return this.errors;
    }

    public List<ValidationIssue> getWarnings() {
        return this.warnings;
    }

    public List<ValidationIssue> getInfos() {
        return this.infos;
    }

    public String toString() {
        return "ValidationResultsBuilder{errors=" + this.errors + ", warnings=" + this.warnings + ", infos=" + this.infos + "}";
    }
}

