/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.InventoryType;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.model.ValidationCode;
import edu.wisc.library.ocfl.api.model.ValidationIssue;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.storage.common.Listing;
import edu.wisc.library.ocfl.core.storage.common.Storage;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemStorage;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.MultiDigestInputStream;
import edu.wisc.library.ocfl.core.util.NamasteTypeFile;
import edu.wisc.library.ocfl.core.validation.ContentPaths;
import edu.wisc.library.ocfl.core.validation.Manifests;
import edu.wisc.library.ocfl.core.validation.SimpleInventoryParser;
import edu.wisc.library.ocfl.core.validation.SimpleInventoryValidator;
import edu.wisc.library.ocfl.core.validation.ValidationResultsBuilder;
import edu.wisc.library.ocfl.core.validation.model.SimpleInventory;
import edu.wisc.library.ocfl.core.validation.model.SimpleVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger LOG = LoggerFactory.getLogger(Validator.class);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Set<String> REGISTERED_EXTENSIONS = Set.of("0004-hashed-n-tuple-storage-layout", "0003-hash-and-id-n-tuple-storage-layout", "0002-flat-direct-storage-layout", "0005-mutable-head", "0001-digest-algorithms", "init");
    private final Storage fileSystem;
    private final SimpleInventoryParser inventoryParser;
    private final SimpleInventoryValidator inventoryValidator;

    public static ValidationResults validateObject(Path objectRoot, boolean checkContentFixity) {
        return new Validator(new FileSystemStorage(objectRoot.getParent())).validateObject(objectRoot.getFileName().toString(), checkContentFixity);
    }

    public static ValidationResults validateInventory(Path inventoryPath) {
        return new Validator(new FileSystemStorage(inventoryPath.getParent())).validateInventory(inventoryPath.getFileName().toString());
    }

    public Validator(Storage fileSystem) {
        this.fileSystem = (Storage)Enforce.notNull((Object)fileSystem, (String)"fileSystem cannot be null");
        this.inventoryParser = new SimpleInventoryParser();
        this.inventoryValidator = new SimpleInventoryValidator();
    }

    public ValidationResults validateObject(String objectRootPath, boolean contentFixityCheck) {
        Enforce.notBlank((String)objectRootPath, (String)"objectRootPath cannot be blank");
        ValidationResultsBuilder results = new ValidationResultsBuilder();
        List<Listing> files = this.listFiles(objectRootPath);
        OcflVersion ocflVersion = this.validateNamaste(objectRootPath, files, results);
        if (ocflVersion != null) {
            String inventoryPath = ObjectPaths.inventoryPath(objectRootPath);
            if (files.contains(Listing.file("inventory.json"))) {
                ParseResult parseResult = this.parseInventory(inventoryPath, results, OcflConstants.VALID_INVENTORY_ALGORITHMS);
                parseResult.inventory.ifPresent(inventory -> this.validateObjectWithInventory(objectRootPath, ocflVersion, files, inventoryPath, (SimpleInventory)inventory, parseResult.digests, parseResult.isValid, contentFixityCheck, results));
            } else {
                results.addIssue(ValidationCode.E063, "Object root inventory not found at %s", inventoryPath);
            }
        }
        return results.build();
    }

    public ValidationResults validateInventory(String inventoryPath) {
        Enforce.notBlank((String)inventoryPath, (String)"inventoryPath cannot be blank");
        if (!this.fileSystem.fileExists(inventoryPath)) {
            throw new OcflInputException("No inventory found at: " + inventoryPath);
        }
        ValidationResultsBuilder results = new ValidationResultsBuilder();
        ParseResult parseResults = this.parseInventory(inventoryPath, results, OcflConstants.VALID_INVENTORY_ALGORITHMS);
        parseResults.inventory.ifPresent(inventory -> {
            ValidationResults validationResults = this.inventoryValidator.validateInventory((SimpleInventory)inventory, inventoryPath, null, null);
            results.addAll(validationResults);
        });
        return results.build();
    }

    private void validateObjectWithInventory(String objectRootPath, OcflVersion ocflVersion, List<Listing> rootFiles, String inventoryPath, SimpleInventory rootInventory, Map<DigestAlgorithm, String> inventoryDigests, boolean inventoryIsValid, boolean contentFixityCheck, ValidationResultsBuilder results) {
        HashSet<String> ignoreFiles = new HashSet<String>();
        ignoreFiles.add("inventory.json");
        ignoreFiles.add(new NamasteTypeFile(ocflVersion.getOcflObjectVersion()).fileName());
        ValidationResults validationResults = this.inventoryValidator.validateInventory(rootInventory, inventoryPath, ocflVersion, SimpleInventoryValidator.VersionEquality.EQUAL);
        results.addAll(validationResults);
        this.validateSidecar(inventoryPath, rootInventory, inventoryDigests, results).ifPresent(ignoreFiles::add);
        Map<VersionNum, String> seenVersions = this.validateObjectRootContents(objectRootPath, rootFiles, ignoreFiles, rootInventory, results);
        if (inventoryIsValid && !validationResults.hasErrors()) {
            rootInventory.getVersions().keySet().stream().filter(version -> !seenVersions.containsValue(version)).forEach(version -> results.addIssue(ValidationCode.E010, "Object root at %s is missing version directory %s", objectRootPath, version));
            String rootDigest = inventoryDigests.get(DigestAlgorithmRegistry.getAlgorithm((String)rootInventory.getDigestAlgorithm()));
            ContentPaths contentFiles = this.findAllContentFiles(objectRootPath, rootInventory, results);
            Manifests manifests = new Manifests(rootInventory);
            this.validateContentFiles(inventoryPath, rootInventory, contentFiles, manifests, results);
            HashMap<String, SimpleInventory> inventoryMap = new HashMap<String, SimpleInventory>();
            inventoryMap.put(rootInventory.getDigestAlgorithm(), rootInventory);
            OcflVersion previousVersion = ocflVersion;
            for (String versionStr : seenVersions.values()) {
                if (Objects.equals(rootInventory.getHead(), versionStr)) {
                    this.validateHeadVersion(objectRootPath, rootInventory, rootDigest, results);
                    continue;
                }
                OcflVersion currentVersion = this.validateVersion(objectRootPath, versionStr, rootInventory, previousVersion, contentFiles, manifests, inventoryMap, results);
                if (currentVersion == null) continue;
                previousVersion = currentVersion;
            }
            if (contentFixityCheck) {
                this.fixityCheck(objectRootPath, rootInventory, manifests, results);
            }
        } else {
            LOG.debug("Skipping further validation of the object at {} because its inventory is invalid", (Object)objectRootPath);
        }
    }

    private OcflVersion validateVersion(String objectRootPath, String versionStr, SimpleInventory rootInventory, OcflVersion ocflVersion, ContentPaths contentFiles, Manifests manifests, Map<String, SimpleInventory> inventoryMap, ValidationResultsBuilder results) {
        OcflVersion thisVersion = null;
        String versionPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionStr);
        String inventoryPath = ObjectPaths.inventoryPath(versionPath);
        String contentDir = this.defaultedContentDir(rootInventory);
        List<Listing> files = this.listFiles(versionPath);
        HashSet<String> ignoreFiles = new HashSet<String>();
        ignoreFiles.add(contentDir);
        if (files.contains(Listing.file("inventory.json"))) {
            ignoreFiles.add("inventory.json");
            ParseResult parseResult = this.parseInventory(inventoryPath, results, OcflConstants.VALID_INVENTORY_ALGORITHMS);
            if (parseResult.inventory.isPresent()) {
                SimpleInventory inventory = parseResult.inventory.get();
                ValidationResults validationResults = this.inventoryValidator.validateInventory(inventory, inventoryPath, ocflVersion, SimpleInventoryValidator.VersionEquality.LESS_THAN_OR_EQUAL);
                results.addAll(validationResults);
                this.validateSidecar(inventoryPath, inventory, parseResult.digests, results).ifPresent(ignoreFiles::add);
                String versionContentDir = this.defaultedContentDir(inventory);
                results.addIssue(this.areEqual(rootInventory.getId(), inventory.getId(), ValidationCode.E110, "Inventory id is inconsistent between versions in %s. Expected: %s; Found: %s", inventoryPath, rootInventory.getId(), inventory.getId())).addIssue(this.areEqual(versionStr, inventory.getHead(), ValidationCode.E040, "Inventory head must be %s in %s", versionStr, inventoryPath)).addIssue(this.areEqual(contentDir, versionContentDir, ValidationCode.E019, "Inventory content directory is inconsistent between versions in %s. Expected: %s; Found: %s", inventoryPath, contentDir, versionContentDir));
                if (parseResult.isValid && !validationResults.hasErrors()) {
                    if (!Objects.equals(rootInventory.getDigestAlgorithm(), inventory.getDigestAlgorithm()) && !manifests.containsAlgorithm(inventory.getDigestAlgorithm())) {
                        manifests.addManifest(inventory);
                        inventoryMap.put(inventory.getDigestAlgorithm(), inventory);
                    }
                    this.validateVersionIsConsistent(versionStr, rootInventory, inventory, inventoryPath, inventoryMap, results);
                    this.validateContentFiles(inventoryPath, inventory, contentFiles, manifests, results);
                    thisVersion = InventoryType.fromValue((String)inventory.getType()).getOcflVersion();
                }
            }
        } else {
            results.addIssue(ValidationCode.W010, "Every version should contain an inventory. Missing: %s", inventoryPath);
        }
        this.validateVersionDirContents(objectRootPath, versionStr, contentDir, files, ignoreFiles, results);
        return thisVersion;
    }

    private void validateHeadVersion(String objectRootPath, SimpleInventory rootInventory, String rootDigest, ValidationResultsBuilder results) {
        String versionStr = rootInventory.getHead();
        String versionPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionStr);
        String inventoryPath = ObjectPaths.inventoryPath(versionPath);
        String contentDir = this.defaultedContentDir(rootInventory);
        List<Listing> files = this.listFiles(versionPath);
        HashSet<String> ignoreFiles = new HashSet<String>();
        ignoreFiles.add(contentDir);
        if (files.contains(Listing.file("inventory.json"))) {
            ignoreFiles.add("inventory.json");
            ignoreFiles.add("inventory.json." + rootInventory.getDigestAlgorithm());
            String sidecarPath = inventoryPath + "." + rootInventory.getDigestAlgorithm();
            String sidecarDigest = this.validateInventorySidecar(sidecarPath, results);
            String inventoryDigest = this.computeInventoryDigest(inventoryPath, DigestAlgorithmRegistry.getAlgorithm((String)rootInventory.getDigestAlgorithm()));
            if (!rootDigest.equalsIgnoreCase(inventoryDigest)) {
                results.addIssue(ValidationCode.E064, "Inventory at %s must be identical to the inventory in the object root", inventoryPath);
            }
            if (sidecarDigest != null && !sidecarDigest.equalsIgnoreCase(inventoryDigest)) {
                results.addIssue(ValidationCode.E060, "Inventory at %s does not match expected %s digest. Expected: %s; Found: %s", inventoryPath, rootInventory.getDigestAlgorithm(), sidecarDigest, inventoryDigest);
            }
        } else {
            results.addIssue(ValidationCode.W010, "Every version should contain an inventory. Missing: %s", inventoryPath);
        }
        this.validateVersionDirContents(objectRootPath, versionStr, contentDir, files, ignoreFiles, results);
    }

    private void validateVersionIsConsistent(String versionStr, SimpleInventory rootInventory, SimpleInventory inventory, String inventoryPath, Map<String, SimpleInventory> inventoryMap, ValidationResultsBuilder results) {
        VersionNum currentVersionNum = VersionNum.fromString((String)versionStr);
        SimpleInventory comparingInventory = inventoryMap.get(inventory.getDigestAlgorithm());
        boolean compareDigests = true;
        if (comparingInventory.getHead().equals(inventory.getHead())) {
            compareDigests = false;
            comparingInventory = rootInventory;
        }
        while (true) {
            String currentVersionStr = currentVersionNum.toString();
            SimpleVersion rootVersion = rootInventory.getVersions().get(currentVersionStr);
            SimpleVersion otherVersion = inventory.getVersions().get(currentVersionStr);
            if (otherVersion == null) {
                results.addIssue(ValidationCode.E066, "Inventory is missing version %s in %s", currentVersionStr, inventoryPath);
            } else {
                this.validateVersionState(comparingInventory, inventory, currentVersionNum, inventoryPath, compareDigests, results);
                results.addIssue(this.areEqual(rootVersion.getCreated(), otherVersion.getCreated(), ValidationCode.W011, "The version created timestamp of version %s in %s is inconsistent with the root inventory", currentVersionStr, inventoryPath)).addIssue(this.areEqual(rootVersion.getMessage(), otherVersion.getMessage(), ValidationCode.W011, "The version message of version %s in %s is inconsistent with the root inventory", currentVersionStr, inventoryPath)).addIssue(this.areEqual(rootVersion.getUser(), otherVersion.getUser(), ValidationCode.W011, "The version user of version %s in %s is inconsistent with the root inventory", currentVersionStr, inventoryPath));
            }
            if (currentVersionNum.equals((Object)VersionNum.V1)) break;
            currentVersionNum = currentVersionNum.previousVersionNum();
        }
    }

    private void validateVersionState(SimpleInventory comparingInventory, SimpleInventory inventory, VersionNum currentVersion, String inventoryPath, boolean compareDigests, ValidationResultsBuilder results) {
        SimpleVersion comparingVersion = comparingInventory.getVersions().get(currentVersion.toString());
        SimpleVersion version = inventory.getVersions().get(currentVersion.toString());
        HashMap<String, String> invertedComparingState = new HashMap<String, String>(comparingVersion.getInvertedState());
        version.getState().forEach((digest, paths) -> paths.forEach(path -> {
            String comparingDigest = (String)invertedComparingState.remove(path);
            if (comparingDigest == null) {
                results.addIssue(ValidationCode.E066, "In %s version %s's state contains a path that does not exist in later inventories: %s", inventoryPath, currentVersion.toString(), path);
            } else if (compareDigests) {
                if (!digest.equalsIgnoreCase(comparingDigest)) {
                    results.addIssue(ValidationCode.E066, "In %s version %s's state contains a path that is inconsistent with later inventories: %s", inventoryPath, currentVersion.toString(), path);
                }
            } else {
                List<String> comparingContentPaths = comparingInventory.getManifest().get(comparingDigest);
                List<String> contentPaths = inventory.getManifest().get(digest);
                if (comparingContentPaths.size() == 1) {
                    if (!comparingContentPaths.equals(contentPaths)) {
                        results.addIssue(ValidationCode.E066, "In %s version %s's state contains a path that is inconsistent with later inventories: %s", inventoryPath, currentVersion.toString(), path);
                    }
                } else {
                    HashSet<String> filteredPaths = new HashSet<String>();
                    for (String contentPath : comparingContentPaths) {
                        VersionNum num = VersionNum.fromString((String)contentPath.substring(0, contentPath.indexOf(47)));
                        if (num.compareTo(currentVersion) > 0) continue;
                        filteredPaths.add(contentPath);
                    }
                    if (!filteredPaths.equals(new HashSet<String>(contentPaths))) {
                        results.addIssue(ValidationCode.E066, "In %s version %s's state contains a path that is inconsistent with later inventories: %s", inventoryPath, currentVersion.toString(), path);
                    }
                }
            }
        }));
        invertedComparingState.keySet().forEach(path -> results.addIssue(ValidationCode.E066, "In %s version %s's state is missing a path that exist in later inventories: %s", inventoryPath, currentVersion.toString(), path));
    }

    private void validateContentFiles(String inventoryPath, SimpleInventory inventory, ContentPaths contentFiles, Manifests manifests, ValidationResultsBuilder results) {
        Map<String, String> invertedManifest = inventory.getInvertedManifestCopy();
        Set<String> fixityPaths = this.getFixityPaths(inventory);
        Iterator<String> it = contentFiles.pathsForVersion(VersionNum.fromString((String)inventory.getHead()));
        while (it.hasNext()) {
            String contentPath2 = it.next();
            String digest = invertedManifest.remove(contentPath2);
            if (digest == null) {
                results.addIssue(ValidationCode.E023, "Object contains a file in version content that is not referenced in the manifest of %s: %s", inventoryPath, contentPath2);
            } else {
                String expectedDigest = manifests.getDigest(inventory.getDigestAlgorithm(), contentPath2);
                if (expectedDigest != null && !digest.equalsIgnoreCase(expectedDigest)) {
                    results.addIssue(ValidationCode.E092, "Inventory manifest entry in %s for content path %s differs from later versions. Expected: %s; Found: %s", inventoryPath, contentPath2, expectedDigest, digest);
                }
            }
            fixityPaths.remove(contentPath2);
        }
        invertedManifest.keySet().forEach(contentPath -> results.addIssue(ValidationCode.E092, "Inventory manifest in %s contains a content path that does not exist: %s", inventoryPath, contentPath));
        fixityPaths.forEach(contentPath -> results.addIssue(ValidationCode.E093, "Inventory fixity in %s contains a content path that does not exist: %s", inventoryPath, contentPath));
    }

    private ContentPaths findAllContentFiles(String objectRootPath, SimpleInventory inventory, ValidationResultsBuilder results) {
        String contentDir = this.defaultedContentDir(inventory);
        HashSet<String> files = new HashSet<String>(inventory.getManifest().size());
        inventory.getVersions().keySet().forEach(versionNum -> {
            String versionContentDir = FileUtil.pathJoinFailEmpty(versionNum, contentDir);
            String versionContentPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionContentDir);
            List<Listing> listings = this.listFilesRecursive(versionContentPath);
            listings.forEach(listing -> {
                String fullPath = FileUtil.pathJoinIgnoreEmpty(versionContentPath, listing.getRelativePath());
                String contentPath = FileUtil.pathJoinIgnoreEmpty(versionContentDir, listing.getRelativePath());
                if (listing.isDirectory() && !versionContentPath.equals(contentPath)) {
                    results.addIssue(ValidationCode.E024, "Object contains an empty directory within version content at %s", fullPath);
                } else {
                    files.add(contentPath);
                }
            });
        });
        return new ContentPaths(files);
    }

    private void fixityCheck(String objectRootPath, SimpleInventory inventory, Manifests manifests, ValidationResultsBuilder results) {
        Map<String, Map<DigestAlgorithm, String>> invertedFixityMap = this.invertFixity(inventory);
        DigestAlgorithm contentAlgorithm = DigestAlgorithmRegistry.getAlgorithm((String)inventory.getDigestAlgorithm());
        HashSet<DigestAlgorithm> contentAlgorithms = new HashSet<DigestAlgorithm>();
        contentAlgorithms.add(contentAlgorithm);
        for (Map.Entry<String, List<String>> entry : inventory.getManifest().entrySet()) {
            String digest = entry.getKey();
            for (String contentPath : entry.getValue()) {
                Map<DigestAlgorithm, String> fixityDigests;
                String storagePath = FileUtil.pathJoinFailEmpty(objectRootPath, contentPath);
                HashMap<DigestAlgorithm, String> expectations = new HashMap<DigestAlgorithm, String>();
                expectations.put(contentAlgorithm, digest);
                if (manifests.hasMultipleAlgorithms()) {
                    manifests.getDigests(contentPath).entrySet().stream().filter(e -> !Objects.equals(e.getKey(), contentAlgorithm.getOcflName())).forEach(e -> {
                        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm((String)((String)e.getKey()));
                        if (algorithm != null) {
                            expectations.put(algorithm, (String)e.getValue());
                            contentAlgorithms.add(algorithm);
                        }
                    });
                }
                if ((fixityDigests = invertedFixityMap.get(contentPath)) != null) {
                    expectations.putAll(fixityDigests);
                }
                try {
                    InputStream contentStream = this.fileSystem.read(storagePath);
                    try {
                        MultiDigestInputStream wrapped = MultiDigestInputStream.create(contentStream, expectations.keySet());
                        while (wrapped.read() != -1) {
                        }
                        Map<DigestAlgorithm, String> actualDigests = wrapped.getResults();
                        expectations.forEach((algorithm, expected) -> {
                            String actual = (String)actualDigests.get(algorithm);
                            if (!expected.equalsIgnoreCase(actual)) {
                                ValidationCode code = contentAlgorithms.contains(algorithm) ? ValidationCode.E092 : ValidationCode.E093;
                                results.addIssue(code, "File %s failed %s fixity check. Expected: %s; Actual: %s", storagePath, algorithm.getOcflName(), expected, actual);
                            }
                        });
                    }
                    finally {
                        if (contentStream == null) continue;
                        contentStream.close();
                    }
                }
                catch (OcflNoSuchFileException contentStream) {
                }
                catch (Exception e2) {
                    results.addIssue(ValidationCode.E092, "Failed to validate fixity of %s: %s", storagePath, e2.getMessage());
                }
            }
        }
    }

    private void validateVersionDirContents(String objectRootPath, String versionStr, String contentDir, List<Listing> files, Set<String> ignoreFiles, ValidationResultsBuilder results) {
        String contentDirPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionStr, contentDir);
        if (files.contains(Listing.directory(contentDir)) && this.listFiles(contentDirPath).isEmpty()) {
            results.addIssue(ValidationCode.W003, "Version content directory exists at %s, but is empty.", contentDirPath);
        }
        for (Listing file : files) {
            String fileName = file.getRelativePath();
            if (ignoreFiles.contains(fileName)) continue;
            if (file.isFile()) {
                results.addIssue(ValidationCode.E015, "Version directory %s in %s contains an unexpected file %s", versionStr, objectRootPath, fileName);
                continue;
            }
            if (file.isDirectory()) {
                results.addIssue(ValidationCode.W002, "Version directory %s in %s contains an unexpected directory %s", versionStr, objectRootPath, fileName);
                continue;
            }
            results.addIssue(ValidationCode.E090, "Version directory %s in %s contains an illegal file %s", versionStr, objectRootPath, fileName);
        }
    }

    private OcflVersion validateNamaste(String objectRootPath, List<Listing> files, ValidationResultsBuilder results) {
        return files.stream().map(Listing::getRelativePath).filter(path -> path.startsWith("0=ocfl_object_")).findFirst().map(path -> {
            OcflVersion version;
            String fullPath = FileUtil.pathJoinIgnoreEmpty(objectRootPath, path);
            try {
                version = OcflVersion.fromOcflObjectVersionFilename((String)path);
            }
            catch (RuntimeException e) {
                results.addIssue(ValidationCode.E003, "Unsupported OCFL object version declaration %s", fullPath);
                return null;
            }
            NamasteTypeFile namaste = new NamasteTypeFile(version.getOcflObjectVersion());
            try (InputStream stream = this.fileSystem.read(fullPath);){
                String contents = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (!namaste.fileContent().equals(contents)) {
                    results.addIssue(ValidationCode.E007, "OCFL object version declaration must be '%s' in %s", namaste.fileContent().trim(), fullPath);
                }
            }
            catch (IOException e) {
                throw new OcflIOException((Exception)e);
            }
            return version;
        }).orElseGet(() -> {
            results.addIssue(ValidationCode.E003, "OCFL object version declaration is missing in %s", objectRootPath);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateInventorySidecar(String sidecarPath, ValidationResultsBuilder results) {
        try (InputStream stream = this.fileSystem.read(sidecarPath);){
            String[] parts = WHITESPACE.split(new String(stream.readAllBytes(), StandardCharsets.UTF_8));
            if (parts.length != 2) {
                results.addIssue(ValidationCode.E061, "Inventory sidecar file at %s is in an invalid format", sidecarPath);
                return null;
            }
            if (!"inventory.json".equals(parts[1])) {
                results.addIssue(ValidationCode.E061, "Inventory sidecar file at %s is in an invalid format", sidecarPath);
            }
            String string = parts[0];
            return string;
        }
        catch (Exception e) {
            LOG.info("Expected file to exist: {}", (Object)sidecarPath, (Object)e);
            results.addIssue(ValidationCode.E058, "Inventory sidecar missing at %s", sidecarPath);
        }
        return null;
    }

    private Map<VersionNum, String> validateObjectRootContents(String objectRootPath, List<Listing> files, Set<String> ignoreFiles, SimpleInventory inventory, ValidationResultsBuilder results) {
        TreeMap<VersionNum, String> seenVersions = new TreeMap<VersionNum, String>(Comparator.naturalOrder().reversed());
        for (Listing file : files) {
            String fileName = file.getRelativePath();
            if (ignoreFiles.contains(fileName)) continue;
            if (Objects.equals("logs", fileName)) {
                if (file.isDirectory()) continue;
                results.addIssue(ValidationCode.E001, "Object logs directory at %s/logs must be a directory", objectRootPath);
                continue;
            }
            if (Objects.equals("extensions", fileName)) {
                if (file.isDirectory()) {
                    this.validateExtensionContents(objectRootPath, results);
                    continue;
                }
                results.addIssue(ValidationCode.E001, "Object extensions directory at %s/extensions must be a directory", objectRootPath);
                continue;
            }
            VersionNum versionNum = this.parseVersionNum(fileName);
            if (versionNum != null && !file.isDirectory()) {
                results.addIssue(ValidationCode.E001, "Object root %s contains version %s but it is a file and must be a directory", objectRootPath);
                continue;
            }
            if (inventory.getVersions() != null && versionNum != null) {
                if (!inventory.getVersions().containsKey(fileName)) {
                    results.addIssue(ValidationCode.E046, "Object root %s contains version directory %s but the version does not exist in the root inventory", objectRootPath, fileName);
                    continue;
                }
                if (versionNum.getZeroPaddingWidth() > 0) {
                    results.addIssue(ValidationCode.W001, "Object contains zero-padded version %s in %s", fileName, objectRootPath);
                }
                seenVersions.put(versionNum, fileName);
                continue;
            }
            if (fileName.startsWith("0=ocfl_object_")) {
                results.addIssue(ValidationCode.E003, "Object root %s contains multiple version declaration files", objectRootPath);
                continue;
            }
            results.addIssue(ValidationCode.E001, "Object root %s contains an unexpected file %s", objectRootPath, fileName);
        }
        return seenVersions;
    }

    private void validateExtensionContents(String objectRootPath, ValidationResultsBuilder results) {
        String dir = FileUtil.pathJoinFailEmpty(objectRootPath, "extensions");
        List<Listing> files = this.listFiles(dir);
        for (Listing file : files) {
            if (file.isDirectory()) {
                if (REGISTERED_EXTENSIONS.contains(file.getRelativePath())) continue;
                results.addIssue(ValidationCode.W013, "Object extensions directory %s contains unregistered extension %s", dir, file.getRelativePath());
                continue;
            }
            results.addIssue(ValidationCode.E067, "Object extensions directory %s cannot contain file %s", dir, file.getRelativePath());
        }
    }

    private Optional<String> validateSidecar(String inventoryPath, SimpleInventory inventory, Map<DigestAlgorithm, String> digests, ValidationResultsBuilder results) {
        DigestAlgorithm algorithm;
        String digest;
        if (inventory.getDigestAlgorithm() != null && (digest = digests.get(algorithm = DigestAlgorithmRegistry.getAlgorithm((String)inventory.getDigestAlgorithm()))) != null) {
            String sidecarPath = inventoryPath + "." + inventory.getDigestAlgorithm();
            String expectedDigest = this.validateInventorySidecar(sidecarPath, results);
            if (expectedDigest != null && !digest.equalsIgnoreCase(expectedDigest)) {
                results.addIssue(ValidationCode.E060, "Inventory at %s does not match expected %s digest. Expected: %s; Found: %s", inventoryPath, algorithm.getOcflName(), expectedDigest, digest);
            }
            return Optional.of("inventory.json." + inventory.getDigestAlgorithm());
        }
        return Optional.empty();
    }

    private ParseResult parseInventory(String inventoryPath, ValidationResultsBuilder results, DigestAlgorithm ... digestAlgorithms) {
        ParseResult parseResult;
        block8: {
            InputStream stream = this.fileSystem.read(inventoryPath);
            try {
                MultiDigestInputStream wrapped = MultiDigestInputStream.create(stream, Arrays.asList(digestAlgorithms));
                SimpleInventoryParser.ParseSimpleInventoryResult parseResult2 = this.inventoryParser.parse(wrapped, inventoryPath);
                results.addAll(parseResult2.getValidationResults());
                ParseResult result = new ParseResult(parseResult2.getInventory(), !parseResult2.getValidationResults().hasErrors());
                wrapped.getResults().forEach(result::withDigest);
                parseResult = result;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException((Exception)e);
                }
            }
            stream.close();
        }
        return parseResult;
    }

    private String computeInventoryDigest(String inventoryPath, DigestAlgorithm algorithm) {
        String string;
        block9: {
            InputStream stream = this.fileSystem.read(inventoryPath);
            try {
                MultiDigestInputStream wrapped = MultiDigestInputStream.create(stream, List.of(algorithm));
                while (wrapped.read() > 0) {
                }
                string = wrapped.getResults().get(algorithm);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException((Exception)e);
                }
            }
            stream.close();
        }
        return string;
    }

    private VersionNum parseVersionNum(String versionNum) {
        try {
            return VersionNum.fromString((String)versionNum);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String defaultedContentDir(SimpleInventory inventory) {
        String content = inventory.getContentDirectory();
        if (content == null || content.isEmpty()) {
            return "content";
        }
        return content;
    }

    private Set<String> getFixityPaths(SimpleInventory inventory) {
        if (inventory.getFixity() == null) {
            return new HashSet<String>();
        }
        return inventory.getFixity().values().stream().flatMap(e -> e.values().stream()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Map<String, Map<DigestAlgorithm, String>> invertFixity(SimpleInventory inventory) {
        if (inventory.getFixity() == null) {
            return new HashMap<String, Map<DigestAlgorithm, String>>();
        }
        HashMap<String, Map<DigestAlgorithm, String>> inverted = new HashMap<String, Map<DigestAlgorithm, String>>();
        inventory.getFixity().forEach((algorithmStr, map) -> {
            DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm((String)algorithmStr);
            if (algorithm != null) {
                map.forEach((digest, paths) -> paths.forEach(path -> inverted.computeIfAbsent((String)path, k -> new HashMap()).put(algorithm, digest)));
            }
        });
        return inverted;
    }

    private Optional<ValidationIssue> areEqual(Object left, Object right, ValidationCode code, String messageTemplate, Object ... args) {
        if (!Objects.equals(left, right)) {
            return Optional.of(this.createIssue(code, messageTemplate, args));
        }
        return Optional.empty();
    }

    private ValidationIssue createIssue(ValidationCode code, String messageTemplate, Object ... args) {
        String message = messageTemplate;
        if (args != null && args.length > 0) {
            message = String.format(messageTemplate, args);
        }
        return new ValidationIssue(code, message);
    }

    private List<Listing> listFiles(String path) {
        try {
            return this.fileSystem.listDirectory(path);
        }
        catch (OcflNoSuchFileException e) {
            return Collections.emptyList();
        }
    }

    private List<Listing> listFilesRecursive(String path) {
        try {
            return this.fileSystem.listRecursive(path);
        }
        catch (OcflNoSuchFileException e) {
            return Collections.emptyList();
        }
    }

    private static class ParseResult {
        final Optional<SimpleInventory> inventory;
        final Map<DigestAlgorithm, String> digests;
        final boolean isValid;

        ParseResult(Optional<SimpleInventory> inventory, boolean isValid) {
            this.inventory = inventory;
            this.isValid = isValid;
            this.digests = new HashMap<DigestAlgorithm, String>();
        }

        ParseResult withDigest(DigestAlgorithm algorithm, String value) {
            this.digests.put(algorithm, value);
            return this;
        }
    }
}

