/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test.matcher;

import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.OcflObjectVersionFile;
import edu.wisc.library.ocfl.test.TestHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class OcflObjectVersionFileMatcher
extends TypeSafeMatcher<OcflObjectVersionFile> {
    private String filePath;
    private String storagePath;
    private String content;
    private Map<DigestAlgorithm, String> fixity;

    OcflObjectVersionFileMatcher(String filePath, String storagePath, String content, Map<DigestAlgorithm, String> fixity) {
        this.filePath = filePath;
        this.storagePath = storagePath;
        this.content = content;
        this.fixity = fixity;
    }

    protected boolean matchesSafely(OcflObjectVersionFile item) {
        return Objects.equals(this.filePath, item.getPath()) && Objects.equals(this.storagePath, item.getStorageRelativePath()) && Objects.equals(this.fixity, item.getFixity()) && this.sameContent(item.getStream());
    }

    private boolean sameContent(FixityCheckInputStream stream) {
        if (this.content != null) {
            String actual = TestHelper.inputToString((InputStream)stream);
            stream.checkFixity();
            return Objects.equals(this.content, actual);
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("FileDetails{filePath=").appendValue((Object)this.filePath).appendText(", storagePath=").appendValue((Object)this.storagePath).appendValue((Object)", content=").appendValue((Object)this.content).appendText(", fixity=").appendValue(this.fixity).appendText("}");
    }
}

