/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test.matcher;

import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.test.matcher.OcflObjectVersionFileMatcher;
import edu.wisc.library.ocfl.test.matcher.VersionInfoMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class OcflObjectVersionMatcher
extends TypeSafeMatcher<OcflObjectVersion> {
    private final String objectId;
    private final VersionNum versionNum;
    private final VersionInfoMatcher versionInfoMatcher;
    private final Collection<OcflObjectVersionFileMatcher> fileMatchers;

    OcflObjectVersionMatcher(String objectId, String versionNum, VersionInfoMatcher versionInfoMatcher, OcflObjectVersionFileMatcher ... fileMatchers) {
        this.objectId = objectId;
        this.versionNum = VersionNum.fromString((String)versionNum);
        this.versionInfoMatcher = versionInfoMatcher;
        this.fileMatchers = Arrays.asList(fileMatchers);
    }

    protected boolean matchesSafely(OcflObjectVersion item) {
        return Objects.equals(this.objectId, item.getObjectId()) && Objects.equals(this.versionNum, item.getVersionNum()) && this.versionInfoMatcher.matches(item.getVersionInfo()) && Matchers.containsInAnyOrder(this.fileMatchers).matches((Object)item.getFiles());
    }

    public void describeTo(Description description) {
        description.appendText("VersionDetails{objectId=").appendValue((Object)this.objectId).appendText(", versionNum=").appendValue((Object)this.versionNum).appendText(", versionInfo=").appendDescriptionOf((SelfDescribing)this.versionInfoMatcher).appendText(", file=").appendList("[", ",", "]", this.fileMatchers).appendText("}");
    }
}

