/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test.matcher;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.FileChange;
import edu.wisc.library.ocfl.api.model.FileChangeType;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.test.matcher.VersionInfoMatcher;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FileChangeMatcher
extends TypeSafeMatcher<FileChange> {
    private FileChangeType changeType;
    private ObjectVersionId objectVersionId;
    private String filePath;
    private String storagePath;
    private Map<DigestAlgorithm, String> fixity;
    private VersionInfoMatcher versionInfoMatcher;

    FileChangeMatcher(FileChangeType changeType, ObjectVersionId objectVersionId, String filePath, String storagePath, VersionInfoMatcher versionInfoMatcher, Map<DigestAlgorithm, String> fixity) {
        this.changeType = changeType;
        this.objectVersionId = objectVersionId;
        this.filePath = filePath;
        this.storagePath = storagePath;
        this.versionInfoMatcher = versionInfoMatcher;
        this.fixity = fixity;
    }

    protected boolean matchesSafely(FileChange item) {
        return Objects.equals(this.filePath, item.getPath()) && Objects.equals(this.changeType, item.getChangeType()) && Objects.equals(this.objectVersionId, item.getObjectVersionId()) && Objects.equals(this.storagePath, item.getStorageRelativePath()) && this.versionInfoMatcher.matches(item.getVersionInfo()) && Objects.equals(this.fixity, item.getFixity());
    }

    public void describeTo(Description description) {
        description.appendText("FileChange{filePath=").appendValue((Object)this.filePath).appendText(", storagePath=").appendValue((Object)this.storagePath).appendText(", changeType=").appendValue((Object)this.changeType).appendText(", objectVersionId=").appendValue((Object)this.objectVersionId).appendText(", fixity=").appendValue(this.fixity).appendText("}");
    }
}

