/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test.matcher;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.FileDetails;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FileDetailsMatcher
extends TypeSafeMatcher<FileDetails> {
    private String filePath;
    private String storagePath;
    private Map<DigestAlgorithm, String> fixity;

    FileDetailsMatcher(String filePath, String storagePath, Map<DigestAlgorithm, String> fixity) {
        this.filePath = filePath;
        this.storagePath = storagePath;
        this.fixity = fixity;
    }

    protected boolean matchesSafely(FileDetails item) {
        return Objects.equals(this.filePath, item.getPath()) && Objects.equals(this.storagePath, item.getStorageRelativePath()) && Objects.equals(this.fixity, item.getFixity());
    }

    public void describeTo(Description description) {
        description.appendText("FileDetails{filePath=").appendValue((Object)this.filePath).appendText(", storagePath=").appendValue((Object)this.storagePath).appendText(", fixity=").appendValue(this.fixity).appendText("}");
    }
}

