/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import java.util.stream.Stream;

public final class TestHelper {
    private TestHelper() {
    }

    public static String fileToString(Path file) {
        String string;
        BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        try {
            string = TestHelper.inputToString(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        input.close();
        return string;
    }

    public static String inputToString(InputStream inputStream) {
        String string = new Scanner(inputStream).useDelimiter("\\A").next();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    public static InputStream inputStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream inputStream(Path path) {
        try {
            return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path copyDir(Path source, Path target) {
        try (Stream<Path> files = Files.walk(source, new FileVisitOption[0]);){
            files.filter(f -> !f.getFileName().toString().equals(".gitkeep")).forEach(f -> {
                try {
                    Files.copy(f, target.resolve(source.relativize((Path)f)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return target;
    }
}

