/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.test.matcher;

import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.test.matcher.FileDetailsMatcher;
import edu.wisc.library.ocfl.test.matcher.VersionInfoMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class VersionDetailsMatcher
extends TypeSafeMatcher<VersionDetails> {
    private final String objectId;
    private final VersionNum versionNum;
    private final VersionInfoMatcher versionInfoMatcher;
    private final Collection<Matcher<FileDetails>> fileDetailsMatchers;

    VersionDetailsMatcher(String objectId, String versionNum, VersionInfoMatcher versionInfoMatcher, FileDetailsMatcher ... fileDetailsMatchers) {
        this.objectId = objectId;
        this.versionNum = VersionNum.fromString((String)versionNum);
        this.versionInfoMatcher = versionInfoMatcher;
        this.fileDetailsMatchers = Arrays.asList(fileDetailsMatchers);
    }

    protected boolean matchesSafely(VersionDetails item) {
        return Objects.equals(this.objectId, item.getObjectId()) && Objects.equals(this.versionNum, item.getVersionNum()) && this.versionInfoMatcher.matches(item.getVersionInfo()) && Matchers.containsInAnyOrder(this.fileDetailsMatchers).matches((Object)item.getFiles());
    }

    public void describeTo(Description description) {
        description.appendText("VersionDetails{objectId=").appendValue((Object)this.objectId).appendText(", versionNum=").appendValue((Object)this.versionNum).appendText(", versionInfo=").appendDescriptionOf((SelfDescribing)this.versionInfoMatcher).appendText(", fileDetails=").appendList("[", ",", "]", this.fileDetailsMatchers).appendText("}");
    }
}

