/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.keyvalue.service;

import edu.wisc.my.keyvalue.model.KeyValue;
import edu.wisc.my.keyvalue.repository.KeyValueRepository;
import edu.wisc.my.keyvalue.service.IKeyValueService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class KeyValueServiceImpl
implements IKeyValueService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private KeyValueRepository keyValueRepository;
    private Environment env;
    private String usernameAttribute;
    private String[] allAttributes;

    @Value(value="${usernameAttribute}")
    public void setUsernameAttr(String attr) {
        this.usernameAttribute = attr;
        String[] tempArray = this.usernameAttribute.split(",");
        this.allAttributes = new String[tempArray.length];
        for (int x = 0; x < tempArray.length; ++x) {
            this.allAttributes[x] = tempArray[x].trim();
        }
    }

    private String[] getAllAttributes() {
        return this.allAttributes;
    }

    private String getAttribute(HttpServletRequest request) {
        for (String attribute : this.getAllAttributes()) {
            if (!StringUtils.isNotBlank((CharSequence)request.getHeader(attribute))) continue;
            return attribute;
        }
        return null;
    }

    @Autowired
    public void setEnv(Environment env) {
        this.env = env;
    }

    @Autowired
    public void setKeyValueRepository(KeyValueRepository keyValueRepository) {
        this.keyValueRepository = keyValueRepository;
    }

    @Override
    public String getValue(HttpServletRequest request, String scope, String key) {
        if (this.isAuthorized(scope, request, IKeyValueService.METHOD.GET)) {
            KeyValue keyValue = this.keyValueRepository.findByKey(this.getPrefix(request, scope) + ":" + key);
            return keyValue != null ? keyValue.getValue() : "";
        }
        throw new SecurityException();
    }

    @Override
    public void setValue(HttpServletRequest request, String scope, String key, String value) {
        if (!this.isAuthorized(scope, request, IKeyValueService.METHOD.PUT)) {
            throw new SecurityException();
        }
        KeyValue keyValue = new KeyValue();
        keyValue.setKey(this.getPrefix(request, scope) + ":" + key);
        keyValue.setValue(value);
        this.keyValueRepository.save(keyValue);
    }

    @Override
    public void delete(HttpServletRequest request, String scope, String key) {
        if (!this.isAuthorized(scope, request, IKeyValueService.METHOD.DELETE)) {
            throw new SecurityException();
        }
        this.keyValueRepository.delete(new KeyValue(this.getPrefix(request, scope) + ":" + key));
    }

    @Override
    public boolean isByUser(String scope) {
        String byUserString = "";
        byUserString = scope != null ? this.env.getRequiredProperty("scope." + scope + ".byUser") : "true";
        this.logger.trace("scope {} byUser? {}.", (Object)scope, (Object)byUserString);
        return byUserString != null && Boolean.parseBoolean(byUserString);
    }

    @Override
    public boolean isAuthorized(String scope, HttpServletRequest request, IKeyValueService.METHOD method) {
        if (this.getAttribute(request) == null) {
            return false;
        }
        if (scope == null) {
            return true;
        }
        if (this.isByUser(scope)) {
            String prefixAttr = this.env.getRequiredProperty("scope." + scope + ".prefixAttribute");
            String filterHeaderValue = request.getHeader(prefixAttr);
            return filterHeaderValue != null;
        }
        if (!IKeyValueService.METHOD.GET.equals((Object)method)) {
            String adminGroup = this.env.getRequiredProperty("scope." + scope + ".admin.group");
            String groupHeader = this.env.getRequiredProperty("groupHeaderAttribute");
            String groups = request.getHeader(groupHeader);
            return groups != null && groups.contains(adminGroup);
        }
        return true;
    }

    private String getPrefix(HttpServletRequest request, String scope) {
        if (this.isByUser(scope)) {
            String username = request.getHeader(this.getAttribute(request));
            return scope != null ? scope + ":" + username : username;
        }
        return scope;
    }
}

