/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.keyvalue.controller;

import edu.wisc.my.keyvalue.service.IKeyValueService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class KeyValueStoreController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IKeyValueService keyValueService;
    private Environment env;
    private String usernameAttribute;
    private static final String ACCESS_ERROR = "No username set in header, entity manager set properly?";

    @Autowired
    public void setEnv(Environment env) {
        this.env = env;
    }

    @Autowired
    public void setKeyValueService(IKeyValueService keyValueService) {
        this.keyValueService = keyValueService;
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public void index(HttpServletResponse response) {
        try {
            JSONObject responseObj = new JSONObject();
            responseObj.put("status", (Object)"up");
            response.getWriter().write(responseObj.toString());
            response.setContentType("application/json");
            response.setStatus(200);
        }
        catch (IOException e) {
            this.logger.error("Issues happened while trying to write Status", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/{scope}/{key}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void putScopedKeyValue(HttpServletRequest request, HttpServletResponse response, @PathVariable String scope, @PathVariable String key, @RequestBody String valueJson) throws IOException {
        this.putInternal(request, response, scope, key, valueJson);
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void setKeyValue(HttpServletRequest request, HttpServletResponse response, @PathVariable String key, @RequestBody String valueJson) {
        this.putInternal(request, response, null, key, valueJson);
    }

    private void putInternal(HttpServletRequest request, HttpServletResponse response, String scope, String key, String value) {
        if (!this.isJSONValid(value)) {
            this.logger.error("Invalid request, json not valid");
            response.setStatus(400);
            return;
        }
        try {
            this.keyValueService.setValue(request, scope, key, value);
            this.writeResponse(response, value);
        }
        catch (SecurityException se) {
            this.logger.error("Access denied", (Throwable)se);
            response.setStatus(403);
        }
    }

    @RequestMapping(value={"/{scope}/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public void getScopedKeyValue(HttpServletRequest request, HttpServletResponse response, @PathVariable String scope, @PathVariable String key) throws IOException {
        this.getInternal(request, response, scope, key);
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public void getKeyValue(HttpServletRequest request, HttpServletResponse response, @PathVariable String key) {
        this.getInternal(request, response, null, key);
    }

    private void getInternal(HttpServletRequest request, HttpServletResponse response, String scope, String key) {
        try {
            String value = this.keyValueService.getValue(request, scope, key);
            if (this.isJSONValid(value)) {
                this.logger.trace("Got something for scope : {}, key : {}, value : {}", new Object[]{scope, key, value});
                this.writeResponse(response, value);
            } else {
                this.logger.trace("Got nothing for scope : {}, key : {}", (Object)scope, (Object)key);
                response.setStatus(204);
            }
        }
        catch (SecurityException se) {
            this.logger.error("Access denied", (Throwable)se);
            response.setStatus(403);
        }
    }

    private void writeResponse(HttpServletResponse response, String json) {
        try {
            response.getWriter().write(json);
            response.setContentType("application/json");
            response.setStatus(200);
        }
        catch (IOException e) {
            this.logger.error("Issues happened while trying to write json", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(HttpServletRequest request, HttpServletResponse response, @PathVariable String key) {
        this.internalDelete(request, response, null, key);
    }

    @RequestMapping(value={"/{scope}/{key}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScoped(HttpServletRequest request, HttpServletResponse response, @PathVariable String scope, @PathVariable String key) {
        this.internalDelete(request, response, scope, key);
    }

    private void internalDelete(HttpServletRequest request, HttpServletResponse response, String scope, String key) {
        try {
            this.keyValueService.delete(request, scope, key);
            response.setStatus(200);
        }
        catch (SecurityException se) {
            this.logger.error("Access denied", (Throwable)se);
            response.setStatus(403);
        }
    }

    private boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }
}

