/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.ltiproxy.dao;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.my.ltiproxy.dao.LTILaunchPropertyFileDao;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@Repository
public class LTILaunchPropertyFileDaoImpl
implements LTILaunchPropertyFileDao {
    private Environment env;
    private ObjectMapper mapper = new ObjectMapper();

    @Autowired
    void setEnv(Environment env) {
        this.env = env;
    }

    @Override
    public Map<String, String> getLaunchParameters(String key) throws JsonParseException, JsonMappingException, IOException {
        String loadedSignedParams = this.env.getProperty(key + ".launchParams");
        HashMap loadedSignedParamMap = (HashMap)this.mapper.readValue(loadedSignedParams, (TypeReference)new TypeReference<Map<String, String>>(){});
        return loadedSignedParamMap;
    }

    @Override
    public Map<String, String[]> getHeadersToReplace(String launchKey) throws JsonParseException, JsonMappingException, IOException {
        String headerReplacementVariables = this.env.getProperty(launchKey + ".headerReplacement");
        HashMap rawHeaderReplacementVariablesMap = (HashMap)this.mapper.readValue(headerReplacementVariables, (TypeReference)new TypeReference<Map<String, String>>(){});
        HashMap<String, String[]> headerReplacementVariableMap = new HashMap<String, String[]>();
        for (String key : rawHeaderReplacementVariablesMap.keySet()) {
            String headersString = (String)rawHeaderReplacementVariablesMap.get(key);
            String[] headers = headersString.split(",");
            headerReplacementVariableMap.put(key, headers);
        }
        return headerReplacementVariableMap;
    }

    @Override
    public String getProperty(String key, String propertyName) {
        return this.env.getProperty(key + "." + propertyName);
    }
}

