/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.ltiproxy.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import edu.wisc.my.ltiproxy.LTIParameters;
import edu.wisc.my.ltiproxy.dao.LTILaunchPropertyFileDao;
import edu.wisc.my.ltiproxy.service.LTILaunchService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.imsglobal.lti.launch.LtiOauthSigner;
import org.imsglobal.lti.launch.LtiSigningException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LTILaunchServiceImpl
implements LTILaunchService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LTILaunchPropertyFileDao LTILaunchPropertyFileDao;
    private static final String UTF8 = StandardCharsets.UTF_8.name();

    @Autowired
    void setLTILaunchProperityFileDao(LTILaunchPropertyFileDao LTILaunchPropertyFileDao2) {
        this.LTILaunchPropertyFileDao = LTILaunchPropertyFileDao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getRedirectUri(String key, Map<String, String> headers) throws JsonParseException, JsonMappingException, IOException, LtiSigningException, URISyntaxException {
        URI result = null;
        Map prepParams = this.prepareParameters(key, headers);
        LTIParameters ltiParams = this.signParameters(key, prepParams);
        String actionUrl = ltiParams.getActionURL();
        List formBody = this.buildFormBody(ltiParams.getSignedParameters());
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResp = null;
        try {
            httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
            HttpPost httpPost = new HttpPost(actionUrl);
            UrlEncodedFormEntity ent = new UrlEncodedFormEntity(formBody);
            httpPost.setEntity((HttpEntity)ent);
            httpResp = httpClient.execute((HttpUriRequest)httpPost);
            int status = httpResp.getStatusLine().getStatusCode();
            this.logger.debug("status " + status);
            for (Header header : httpResp.getAllHeaders()) {
                this.logger.trace(header.getName() + " : " + header.getValue());
            }
            HttpEntity respEntity = httpResp.getEntity();
            byte[] b = EntityUtils.toByteArray((HttpEntity)respEntity);
            EntityUtils.consumeQuietly((HttpEntity)respEntity);
            this.logger.trace(new String(b));
            if (303 == status) {
                String loc = httpResp.getLastHeader("Location").getValue();
                this.logger.trace(loc);
                result = new URI(loc);
            }
        }
        finally {
            if (null != httpClient) {
                httpClient.close();
            }
            if (null != httpResp) {
                httpResp.close();
            }
        }
        return result;
    }

    public JSONObject getFormData(String key, Map<String, String> headers) throws JsonParseException, JsonMappingException, IOException, LtiSigningException, JSONException {
        Map prepParams = this.prepareParameters(key, headers);
        LTIParameters ltiParams = this.signParameters(key, prepParams);
        JSONObject jsonToReturn = new JSONObject();
        jsonToReturn.put("action", (Object)ltiParams.getActionURL());
        JSONArray formInputs = new JSONArray();
        for (Map.Entry entry : ltiParams.getSignedParameters().entrySet()) {
            JSONObject entryObject = new JSONObject();
            entryObject.put("name", entry.getKey());
            entryObject.put("value", entry.getValue());
            formInputs.put((Object)entryObject);
        }
        jsonToReturn.put("formInputs", (Object)formInputs);
        return jsonToReturn;
    }

    private Map<String, String> prepareParameters(String key, Map<String, String> requestHeaders) throws JsonParseException, JsonMappingException, IOException, LtiSigningException, JSONException {
        Map launchParameters = this.LTILaunchPropertyFileDao.getLaunchParameters(key);
        TreeMap<String, String> paramsToSign = new TreeMap<String, String>();
        paramsToSign.putAll(launchParameters);
        paramsToSign.putAll(this.replaceHeaders(key, requestHeaders));
        return paramsToSign;
    }

    private LTIParameters signParameters(String key, Map<String, String> paramsToSign) throws LtiSigningException {
        LtiOauthSigner ltiSigner = new LtiOauthSigner();
        String ltiKey = this.LTILaunchPropertyFileDao.getProperty(key, "key");
        String ltiSecret = this.LTILaunchPropertyFileDao.getProperty(key, "secret");
        String ltiActionUrl = this.LTILaunchPropertyFileDao.getProperty(key, "actionURL");
        Map signedParameters = ltiSigner.signParameters(paramsToSign, ltiKey, ltiSecret, ltiActionUrl, "POST");
        LTIParameters result = new LTIParameters(ltiActionUrl, signedParameters);
        return result;
    }

    private Map<String, String> replaceHeaders(String key, Map<String, String> requestHeaders) throws JsonParseException, JsonMappingException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Map headersToReplace = this.LTILaunchPropertyFileDao.getHeadersToReplace(key);
        block0: for (String headerToReplace : headersToReplace.keySet()) {
            String[] headerAttributes;
            for (String header : headerAttributes = (String[])headersToReplace.get(headerToReplace)) {
                if (requestHeaders.get(header) == null) continue;
                headers.put(headerToReplace, requestHeaders.get(header));
                continue block0;
            }
        }
        return headers;
    }

    private List<NameValuePair> buildFormBody(Map<String, String> parameters) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return result;
    }
}

