/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.ltiproxy.web;

import com.google.common.base.Strings;
import edu.wisc.my.ltiproxy.service.LTILaunchService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.ClientProtocolException;
import org.imsglobal.lti.launch.LtiSigningException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/lti-launch"})
public class LTIController {
    private LTILaunchService LTILaunchService;

    @Autowired
    public void setLTILaunchService(LTILaunchService LTILaunchService2) {
        this.LTILaunchService = LTILaunchService2;
    }

    @RequestMapping(value={"/go/{key}"}, method={RequestMethod.GET})
    public void proxyRedirect(HttpServletRequest request, HttpServletResponse response, @PathVariable String key) throws ClientProtocolException, IOException, LtiSigningException, URISyntaxException {
        URI uri = this.LTILaunchService.getRedirectUri(key, LTIController.getHeaders((HttpServletRequest)request));
        if (null != uri) {
            response.sendRedirect(uri.toString());
        } else {
            String errorMsg = "Could not build redirect URI" + (!Strings.isNullOrEmpty((String)key) ? " for " + key : "");
            response.sendError(400, errorMsg);
        }
    }

    @RequestMapping(value={"/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object proxyResource(HttpServletRequest request, HttpServletResponse response, @PathVariable String key) throws ClientProtocolException, IOException, LtiSigningException, JSONException {
        JSONObject jsonToReturn = this.LTILaunchService.getFormData(key, LTIController.getHeaders((HttpServletRequest)request));
        response.setStatus(200);
        return jsonToReturn.toString();
    }

    public static Map<String, String> getHeaders(HttpServletRequest req) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String headerName : Collections.list(req.getHeaderNames())) {
            result.put(headerName.toLowerCase(), req.getHeader(headerName));
        }
        return result;
    }
}

