/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.rssToJson.dao;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import edu.wisc.my.rssToJson.dao.RssToJsonDao;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@PropertySource(value={"classpath:endpoint.properties"})
@Repository
public class RssToJsonDaoImpl
implements RssToJsonDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Environment env;

    @Autowired
    void setEnv(Environment env) {
        this.env = env;
    }

    @Override
    @Cacheable(cacheNames={"feeds"}, sync=true)
    public SyndFeed getRssFeed(String feedEndpoint) {
        this.logger.info("Fetching feed for {} ", (Object)feedEndpoint);
        String endpointURL = this.env.getProperty(feedEndpoint);
        if (endpointURL == null) {
            this.logger.warn("No corresponding feed url for requested endpoint {}", (Object)feedEndpoint);
            return null;
        }
        SyndFeed feed = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(endpointURL);
            request.setHeader("User-Agent", "rss-to-json service");
            request.setHeader("Content-Encoding", "UTF-8");
            HttpResponse response = client.execute((HttpUriRequest)request);
            SyndFeedInput input = new SyndFeedInput();
            feed = input.build((Reader)new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            feed.setFeedType("UTF-8");
            this.logger.debug("CONTENT OF FEED " + endpointURL);
            this.logger.debug(feed.toString());
        }
        catch (Exception ex) {
            this.logger.error("Error while fetching xml from {}", (Object)endpointURL, (Object)ex);
        }
        return feed;
    }
}

