/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.rssToJson.service;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import edu.wisc.my.rssToJson.dao.RssToJsonDao;
import edu.wisc.my.rssToJson.service.RssToJsonService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsstoJsonServiceImpl
implements RssToJsonService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RssToJsonDao rssToJsonDao;

    @Autowired
    void setRssToJsonDao(RssToJsonDao rssToJsonDao) {
        this.rssToJsonDao = rssToJsonDao;
    }

    @Override
    public JSONObject getJsonFromURL(String endpoint) {
        SyndFeed feed = this.rssToJsonDao.getRssFeed(endpoint);
        if (feed == null) {
            this.logger.warn("No feed returned for endpoint: {}", (Object)endpoint);
            return null;
        }
        JSONObject jsonToReturn = new JSONObject();
        JSONObject feedInfo = new JSONObject();
        feedInfo.put("title", (Object)feed.getTitle());
        feedInfo.put("link", (Object)feed.getLink());
        feedInfo.put("description", (Object)feed.getDescription());
        feedInfo.put("pubDate", (Object)feed.getPublishedDate());
        jsonToReturn.put("feed", (Object)feedInfo);
        JSONArray entries = new JSONArray();
        for (SyndEntry entry : feed.getEntries()) {
            JSONObject feedItem = new JSONObject();
            feedItem.put("title", (Object)entry.getTitle());
            feedItem.put("link", (Object)entry.getLink());
            feedItem.put("description", (Object)entry.getDescription().getValue());
            feedItem.put("pubDate", (Object)entry.getPublishedDate());
            entries.put((Object)feedItem);
        }
        jsonToReturn.put("items", (Object)entries);
        jsonToReturn.put("status", (Object)"ok");
        String stringToClean = jsonToReturn.toString();
        stringToClean = stringToClean.replaceAll("\\\\u2019", "'");
        stringToClean = stringToClean.replaceAll("\\\\u2014", "-");
        return new JSONObject(stringToClean);
    }
}

