/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.rssToJson.controller;

import edu.wisc.my.rssToJson.service.RssToJsonService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RssToJsonController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RssToJsonService rssToJsonService;

    @Autowired
    public void setRSSToJSONService(RssToJsonService rssToJsonService) {
        this.rssToJsonService = rssToJsonService;
    }

    @RequestMapping(value={"/rssTransform/{feed}"})
    @ResponseBody
    public void getJsonifiedRssUrl(HttpServletRequest request, HttpServletResponse response, @PathVariable String feed) {
        this.logger.debug("Attempting to retrieve feed for endpoint {}", (Object)feed);
        JSONObject jsonToReturn = this.rssToJsonService.getJsonFromURL(feed);
        if (jsonToReturn == null) {
            this.logger.error("No feed for endpoint {}", (Object)feed);
            response.setStatus(500);
        } else {
            response.setContentType("application/json");
            try {
                response.getWriter().write(jsonToReturn.toString());
                response.setStatus(200);
            }
            catch (IOException e) {
                response.setStatus(500);
            }
        }
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public void index(HttpServletResponse response) {
        try {
            JSONObject responseObj = new JSONObject();
            responseObj.put("status", (Object)"up");
            response.getWriter().write(responseObj.toString());
            response.setContentType("application/json");
            response.setStatus(200);
        }
        catch (IOException e) {
            this.logger.error("Issues happened while trying to write Status", (Throwable)e);
            response.setStatus(500);
        }
    }
}

