!function(a){"use strict";/**
   * @ngdoc overview
   * @name angulartics.clicky
   * Adds support for Clicky analytics (http://clicky.com/).
   * Custom logging is a premium Clicky feature. To use this plugin,
   * clicky needs to be configured to disable automatic pageview logging
   * and history logging:
   *
   * ````
   * var clicky_custom = { pageview_disable : 1, history_disable : 1 };
   * ````
   */
a.module("angulartics.clicky",["angulartics"]).config(["$analyticsProvider","$documentProvider",function(b,c){/**
       * Register Clicky page and event tracking
       * @param {function} clicky - the clicky API function
       */
function d(a){i=a,i&&(b.registerPageTrack(e),b.registerEventTrack(f))}/**
       * Track pageview with Clicky
       * @param {string} path
       */
function e(a,b){var c=b.title||j[0].title,d=g(b.type);i.log(a,c,d)}/**
       * registerEventTrack handler. If `properties.goal` is defined, a clicky.goal() is logged,
       * otherwise the clicky.log() is used.
       * @param action
       * @param properties
       */
function f(b,c){
// goals parameters
var d,e,f,j,k;
// if a goal is sent, use the Clicky goal method, otherwise reroute to log
a.isDefined(c.goal)?(d=c.goal,e=h(c.revenue)?c.revenue:void 0,f=!!c.noQueue,i.goal(d,e,f)):(k=g(c.type)===c.type?c.type:"click",j=c.title||c.value,i.log(b,j,k))}/**
       * Validates against Clicky's enumerated values for the page type.
       * The default type is `click`, but we're choosing a default of
       * `pageview` since pageTrack happens during route change
       * @param type
       * @returns {boolean|string}
       * @link http://clicky.com/help/customization/manual#log
       */
function g(a){var b=["click","download","outbound","pageview"];return b.indexOf(a)>=0?a:"pageview"}/**
       * Returns true if a finite number
       * @param number
       * @returns {boolean}
       */
function h(a){return"number"==typeof a&&isFinite(a)}var i,j=c.$get;b.settings.pageTracking.trackRelativePath=!0,angulartics.waitForVendorApi("clicky",100,d)}])}(angular);