/*
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
'use strict';
/* eslint-env node */
/* global inject */
define(['angular-mocks', 'portal'], function() {
    describe('PortalMainController', function() {
        var scope;
        var $localStorage;
        // eslint-disable-next-line no-unused-vars
        var controller;

        beforeEach(function() {
          module('portal');
        });

        beforeEach(inject(function($rootScope, $controller, _$localStorage_) {
          scope = $rootScope.$new();
          $localStorage = _$localStorage_;
          controller = $controller('PortalMainController', {
            '$localStorage': $localStorage,
            '$scope': scope,
          });
        }));

        it('should set storage in scope', function() {
            expect(scope.$storage).not.toBeNull();
        });

        it('should have an app name defined', function() {
            expect(scope.NAMES.title).not.toBeNull();
        });
    });
});
