/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy.service;

import edu.wisc.my.restproxy.KeyUtils;
import edu.wisc.my.restproxy.ProxyRequestContext;
import edu.wisc.my.restproxy.dao.RestProxyDao;
import edu.wisc.my.restproxy.service.RestProxyService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerMapping;

@Service
public class RestProxyServiceImpl
implements RestProxyService {
    @Autowired
    private Environment env;
    @Autowired
    private RestProxyDao proxyDao;
    private static final Logger logger = LoggerFactory.getLogger(RestProxyServiceImpl.class);

    void setEnv(Environment env) {
        this.env = env;
    }

    @Override
    public Object proxyRequest(String resourceKey, HttpServletRequest request) {
        String resourceRoot = this.env.getProperty(resourceKey + ".uri");
        if (StringUtils.isBlank((CharSequence)resourceRoot)) {
            logger.info("unknown resourceKey {}", (Object)resourceKey);
            return null;
        }
        StringBuilder uri = new StringBuilder(resourceRoot);
        String resourcePath = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
            if (!StringUtils.endsWith((CharSequence)uri, (CharSequence)"/") && !resourcePath.startsWith("/")) {
                uri.append("/");
            }
            uri.append(resourcePath);
        }
        String username = this.env.getProperty(resourceKey + ".username");
        String password = this.env.getProperty(resourceKey + ".password");
        ProxyRequestContext context = new ProxyRequestContext(resourceKey).setAttributes(KeyUtils.getHeaders(this.env, request, resourceKey)).setHttpMethod(HttpMethod.valueOf((String)request.getMethod())).setPassword(password != null ? password.getBytes() : null).setHeaders(KeyUtils.getProxyHeaders(this.env, resourceKey, request)).setUri(uri.toString()).setUsername(username);
        logger.debug("proxying request {}", (Object)context);
        return this.proxyDao.proxyRequest(context);
    }
}

