/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;

public class ProxyRequestContext {
    private final String resourceKey;
    private HttpMethod httpMethod = HttpMethod.GET;
    private String uri;
    private String username;
    private String password;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Multimap<String, String> headers = ArrayListMultimap.create();

    public ProxyRequestContext(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public ProxyRequestContext setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public ProxyRequestContext setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ProxyRequestContext setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyRequestContext setPassword(String password) {
        this.password = password;
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public ProxyRequestContext setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public ProxyRequestContext setHeaders(Multimap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String toString() {
        return "ProxyRequestContext [resourceKey=" + this.resourceKey + ", httpMethod=" + this.httpMethod + ", uri=" + this.uri + ", username=" + this.username + ", password=" + (this.password != null ? "<set, suppressed>" : "empty") + ", attributes=" + this.attributes + ", headers=" + this.headers + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.httpMethod == null ? 0 : this.httpMethod.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.resourceKey == null ? 0 : this.resourceKey.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyRequestContext other = (ProxyRequestContext)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.httpMethod != other.httpMethod) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.resourceKey == null ? other.resourceKey != null : !this.resourceKey.equals(other.resourceKey)) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

