/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.wisc.my.restproxy.dao.GenericRestLookupDao;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Repository;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Repository
public class GenericRestLookupDaoImpl
implements GenericRestLookupDao {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object getStuff(String uri, Map<String, String> attributes) {
        RestTemplate restTemplate = new RestTemplate();
        Object response = restTemplate.getForObject(uri, Object.class, attributes);
        if (this.log.isTraceEnabled()) {
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            try {
                String json = ow.writeValueAsString(response);
                this.log.trace("Response from uri: " + uri + " Response: " + json);
            }
            catch (JsonProcessingException e) {
                this.log.warn("Opps, couldn't parse JSON in trace mode.", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    public Object getStuffWithAuth(String uri, String username, String password, HttpMethod method, Map<String, String> attributes) {
        RestTemplate restTemplate = new RestTemplate();
        String creds = username + ":" + password;
        byte[] plainCredsBytes = creds.getBytes();
        byte[] base64CredsBytes = Base64.encodeBase64((byte[])plainCredsBytes);
        String base64Creds = new String(base64CredsBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(uri, method, request, Object.class, attributes);
        Object responseBody = response.getBody();
        return responseBody;
    }
}

