/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.PropertyPlaceholderHelper;

public final class KeyUtils {
    private static final String END_PLACEHOLDER = "}";
    private static final String START_PLACEHOLDER = "{";
    private static final Logger logger = LoggerFactory.getLogger(KeyUtils.class);

    private KeyUtils() {
    }

    public static Map<String, String> getHeaders(Environment env, HttpServletRequest request, String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        String attributes = env.getProperty(key + ".attributes");
        if (StringUtils.isNotBlank((CharSequence)attributes)) {
            for (String attribute : attributes.split(",")) {
                map.put(attribute, request.getHeader(attribute));
            }
        }
        return map;
    }

    public static Multimap<String, String> getProxyHeaders(Environment env, String resourceKey, final HttpServletRequest request) {
        ArrayListMultimap headers = ArrayListMultimap.create();
        String proxyHeadersValue = env.getProperty(resourceKey + ".proxyHeaders");
        if (proxyHeadersValue != null) {
            String[] proxyHeaders;
            for (String proxyHeader : proxyHeaders = StringUtils.split((String)proxyHeadersValue, (String)",")) {
                String[] tokens = StringUtils.trim((String)proxyHeader).split(":");
                if (tokens.length == 2) {
                    PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper(START_PLACEHOLDER, END_PLACEHOLDER);
                    String value = helper.replacePlaceholders(tokens[1], new PropertyPlaceholderHelper.PlaceholderResolver(){

                        public String resolvePlaceholder(String placeholderName) {
                            Object attribute = request.getAttribute(placeholderName);
                            if (attribute != null && attribute instanceof String) {
                                return (String)attribute;
                            }
                            logger.warn("configuration error: could not resolve placeholder for attribute {} as it's not a String, it's a {}", (Object)placeholderName, attribute != null ? attribute.getClass() : null);
                            return null;
                        }
                    });
                    if ((value = StringUtils.trim((String)value)) == null || value.startsWith(START_PLACEHOLDER) || value.endsWith(END_PLACEHOLDER)) continue;
                    headers.put((Object)tokens[0], (Object)value);
                    continue;
                }
                logger.warn("configuration error: can't split {} on ':', ignoring", (Object)proxyHeader);
            }
        }
        return headers;
    }
}

