/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy.dao;

import edu.wisc.my.restproxy.ProxyRequestContext;
import edu.wisc.my.restproxy.dao.RestProxyDao;
import edu.wisc.my.restproxy.dao.RestProxyResponseErrorHandler;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Service
public class RestProxyDaoImpl
implements RestProxyDao,
InitializingBean {
    @Autowired(required=false)
    private RestTemplate restTemplate = new RestTemplate();
    private static final Logger logger = LoggerFactory.getLogger(RestProxyDaoImpl.class);

    public void afterPropertiesSet() throws Exception {
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new RestProxyResponseErrorHandler());
    }

    @Override
    public ResponseEntity<Object> proxyRequest(ProxyRequestContext context) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)context.getUsername()) && null != context.getPassword()) {
            StringBuffer credsBuffer = new StringBuffer(context.getUsername());
            credsBuffer.append(":");
            credsBuffer.append(context.getPassword());
            String creds = credsBuffer.toString();
            byte[] base64CredsBytes = Base64.encodeBase64((byte[])creds.getBytes());
            String base64Creds = new String(base64CredsBytes);
            headers.add("Authorization", "Basic " + base64Creds);
        }
        for (Map.Entry entry : context.getHeaders().entries()) {
            headers.add((String)entry.getKey(), (String)entry.getValue());
        }
        HttpEntity request = context.getRequestBody() == null ? new HttpEntity((MultiValueMap)headers) : new HttpEntity((Object)context.getRequestBody().getBody(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(context.getUri(), context.getHttpMethod(), request, Object.class, context.getAttributes());
        logger.trace("completed request for {}, response= {}", (Object)context, (Object)response);
        return response;
    }
}

