/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String DIRECTIVE_NO_STORE = "no-store";
    private static final boolean responseGetHeaderAvailable = ClassUtils.hasMethod(HttpServletResponse.class, (String)"getHeader", (Class[])new Class[]{String.class});

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object responseToUse = response;
        if (!this.isAsyncDispatch(request) && !(response instanceof ContentCachingResponseWrapper)) {
            responseToUse = new ContentCachingResponseWrapper(response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)responseToUse);
        if (!this.isAsyncStarted(request)) {
            this.updateResponse(request, (HttpServletResponse)responseToUse);
        }
    }

    private void updateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ContentCachingResponseWrapper responseWrapper = WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        Assert.notNull((Object)((Object)responseWrapper), (String)"ShallowEtagResponseWrapper not found");
        HttpServletResponse rawResponse = (HttpServletResponse)responseWrapper.getResponse();
        int statusCode = responseWrapper.getStatusCode();
        byte[] body = responseWrapper.getContentAsByteArray();
        if (rawResponse.isCommitted()) {
            if (body.length > 0) {
                StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
            }
        } else if (this.isEligibleForEtag(request, (HttpServletResponse)responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            rawResponse.setHeader(HEADER_ETAG, responseETag);
            String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] equal to If-None-Match, sending 304"));
                }
                rawResponse.setStatus(304);
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response"));
                }
                if (body.length > 0) {
                    rawResponse.setContentLength(body.length);
                    StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
                }
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Response with status code [" + statusCode + "] not eligible for ETag"));
            }
            if (body.length > 0) {
                rawResponse.setContentLength(body.length);
                StreamUtils.copy((byte[])body, (OutputStream)rawResponse.getOutputStream());
            }
        }
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, byte[] responseBody) {
        if (responseStatusCode >= 200 && responseStatusCode < 300 && HttpMethod.GET.name().equals(request.getMethod())) {
            String cacheControl;
            String string = cacheControl = responseGetHeaderAvailable ? response.getHeader(HEADER_CACHE_CONTROL) : null;
            if (cacheControl == null || !cacheControl.contains(DIRECTIVE_NO_STORE)) {
                return true;
            }
        }
        return false;
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }
}

