/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestConditionHolder;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;

public final class RequestMappingInfo
implements RequestCondition<RequestMappingInfo> {
    private final String name;
    private final PatternsRequestCondition patternsCondition;
    private final RequestMethodsRequestCondition methodsCondition;
    private final ParamsRequestCondition paramsCondition;
    private final HeadersRequestCondition headersCondition;
    private final ConsumesRequestCondition consumesCondition;
    private final ProducesRequestCondition producesCondition;
    private final RequestConditionHolder customConditionHolder;

    public RequestMappingInfo(String name, PatternsRequestCondition patterns, RequestMethodsRequestCondition methods, ParamsRequestCondition params, HeadersRequestCondition headers, ConsumesRequestCondition consumes, ProducesRequestCondition produces, RequestCondition<?> custom) {
        this.name = StringUtils.hasText((String)name) ? name : null;
        this.patternsCondition = patterns != null ? patterns : new PatternsRequestCondition(new String[0]);
        this.methodsCondition = methods != null ? methods : new RequestMethodsRequestCondition(new RequestMethod[0]);
        this.paramsCondition = params != null ? params : new ParamsRequestCondition(new String[0]);
        this.headersCondition = headers != null ? headers : new HeadersRequestCondition(new String[0]);
        this.consumesCondition = consumes != null ? consumes : new ConsumesRequestCondition(new String[0]);
        this.producesCondition = produces != null ? produces : new ProducesRequestCondition(new String[0]);
        this.customConditionHolder = new RequestConditionHolder(custom);
    }

    public RequestMappingInfo(PatternsRequestCondition patterns, RequestMethodsRequestCondition methods, ParamsRequestCondition params, HeadersRequestCondition headers, ConsumesRequestCondition consumes, ProducesRequestCondition produces, RequestCondition<?> custom) {
        this(null, patterns, methods, params, headers, consumes, produces, custom);
    }

    public RequestMappingInfo(RequestMappingInfo info, RequestCondition<?> customRequestCondition) {
        this(info.name, info.patternsCondition, info.methodsCondition, info.paramsCondition, info.headersCondition, info.consumesCondition, info.producesCondition, customRequestCondition);
    }

    public String getName() {
        return this.name;
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.patternsCondition;
    }

    public RequestMethodsRequestCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public ParamsRequestCondition getParamsCondition() {
        return this.paramsCondition;
    }

    public HeadersRequestCondition getHeadersCondition() {
        return this.headersCondition;
    }

    public ConsumesRequestCondition getConsumesCondition() {
        return this.consumesCondition;
    }

    public ProducesRequestCondition getProducesCondition() {
        return this.producesCondition;
    }

    public RequestCondition<?> getCustomCondition() {
        return this.customConditionHolder.getCondition();
    }

    @Override
    public RequestMappingInfo combine(RequestMappingInfo other) {
        String name = this.combineNames(other);
        PatternsRequestCondition patterns = this.patternsCondition.combine(other.patternsCondition);
        RequestMethodsRequestCondition methods = this.methodsCondition.combine(other.methodsCondition);
        ParamsRequestCondition params = this.paramsCondition.combine(other.paramsCondition);
        HeadersRequestCondition headers = this.headersCondition.combine(other.headersCondition);
        ConsumesRequestCondition consumes = this.consumesCondition.combine(other.consumesCondition);
        ProducesRequestCondition produces = this.producesCondition.combine(other.producesCondition);
        RequestConditionHolder custom = this.customConditionHolder.combine(other.customConditionHolder);
        return new RequestMappingInfo(name, patterns, methods, params, headers, consumes, produces, custom.getCondition());
    }

    private String combineNames(RequestMappingInfo other) {
        if (this.name != null && other.name != null) {
            String separator = "#";
            return this.name + separator + other.name;
        }
        if (this.name != null) {
            return this.name;
        }
        return other.name != null ? other.name : null;
    }

    @Override
    public RequestMappingInfo getMatchingCondition(HttpServletRequest request) {
        RequestMethodsRequestCondition methods = this.methodsCondition.getMatchingCondition(request);
        ParamsRequestCondition params = this.paramsCondition.getMatchingCondition(request);
        HeadersRequestCondition headers = this.headersCondition.getMatchingCondition(request);
        ConsumesRequestCondition consumes = this.consumesCondition.getMatchingCondition(request);
        ProducesRequestCondition produces = this.producesCondition.getMatchingCondition(request);
        if (methods == null || params == null || headers == null || consumes == null || produces == null) {
            return null;
        }
        PatternsRequestCondition patterns = this.patternsCondition.getMatchingCondition(request);
        if (patterns == null) {
            return null;
        }
        RequestConditionHolder custom = this.customConditionHolder.getMatchingCondition(request);
        if (custom == null) {
            return null;
        }
        return new RequestMappingInfo(this.name, patterns, methods, params, headers, consumes, produces, custom.getCondition());
    }

    @Override
    public int compareTo(RequestMappingInfo other, HttpServletRequest request) {
        int result = this.patternsCondition.compareTo(other.getPatternsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.paramsCondition.compareTo(other.getParamsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.headersCondition.compareTo(other.getHeadersCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.consumesCondition.compareTo(other.getConsumesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.producesCondition.compareTo(other.getProducesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.methodsCondition.compareTo(other.getMethodsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.customConditionHolder.compareTo(other.customConditionHolder, request);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof RequestMappingInfo) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.patternsCondition.equals(other.patternsCondition) && this.methodsCondition.equals(other.methodsCondition) && this.paramsCondition.equals(other.paramsCondition) && this.headersCondition.equals(other.headersCondition) && this.consumesCondition.equals(other.consumesCondition) && this.producesCondition.equals(other.producesCondition) && this.customConditionHolder.equals(other.customConditionHolder);
        }
        return false;
    }

    public int hashCode() {
        return this.patternsCondition.hashCode() * 31 + this.methodsCondition.hashCode() + this.paramsCondition.hashCode() + this.headersCondition.hashCode() + this.consumesCondition.hashCode() + this.producesCondition.hashCode() + this.customConditionHolder.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(this.patternsCondition);
        if (!this.methodsCondition.isEmpty()) {
            builder.append(",methods=").append(this.methodsCondition);
        }
        if (!this.paramsCondition.isEmpty()) {
            builder.append(",params=").append(this.paramsCondition);
        }
        if (!this.headersCondition.isEmpty()) {
            builder.append(",headers=").append(this.headersCondition);
        }
        if (!this.consumesCondition.isEmpty()) {
            builder.append(",consumes=").append(this.consumesCondition);
        }
        if (!this.producesCondition.isEmpty()) {
            builder.append(",produces=").append(this.producesCondition);
        }
        if (!this.customConditionHolder.isEmpty()) {
            builder.append(",custom=").append(this.customConditionHolder);
        }
        builder.append('}');
        return builder.toString();
    }
}

