/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy.service;

import edu.wisc.my.restproxy.ProxyRequestContext;
import edu.wisc.my.restproxy.ValidationResult;
import edu.wisc.my.restproxy.dao.RestProxyDao;
import edu.wisc.my.restproxy.service.RestProxyServiceImpl;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;

@RunWith(value=MockitoJUnitRunner.class)
public class RestProxyServiceImplTest
implements GroovyObject {
    private MockEnvironment env;
    @Mock
    private RestProxyDao proxyDao;
    @InjectMocks
    private RestProxyServiceImpl proxy;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RestProxyServiceImplTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(MockEnvironment.class);
        this.env = (MockEnvironment)ScriptBytecodeAdapter.castToType((Object)object, MockEnvironment.class);
        Object object2 = callSiteArray[1].callConstructor(RestProxyServiceImpl.class);
        this.proxy = (RestProxyServiceImpl)ScriptBytecodeAdapter.castToType((Object)object2, RestProxyServiceImpl.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Before
    public void setup() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        callSiteArray[2].call((Object)this.proxy, (Object)this.env);
    }

    @Test
    public void proxyRequest_control() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(ResponseEntity.class, callSiteArray[4].callConstructor(Object.class), callSiteArray[5].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[7].call((Object)request, (Object)"GET");
        callSiteArray[8].call((Object)request, callSiteArray[9].callGetProperty(HandlerMapping.class), (Object)"/control/foo");
        callSiteArray[10].call((Object)this.env, (Object)"control.uri", (Object)"http://destination");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].callConstructor(ProxyRequestContext.class, (Object)"control"), (Object)"http://destination/foo"), ProxyRequestContext.class);
        callSiteArray[13].call(callSiteArray[14].callStatic(Mockito.class, callSiteArray[15].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[16].callStatic(Assert.class, (Object)result, callSiteArray[17].call((Object)this.proxy, (Object)"control", (Object)request));
    }

    @Test
    public void withQueryString() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callConstructor(ResponseEntity.class, callSiteArray[19].callConstructor(Object.class), callSiteArray[20].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[22].call((Object)request, (Object)"GET");
        callSiteArray[23].call((Object)request, callSiteArray[24].callGetProperty(HandlerMapping.class), (Object)"/control/foo");
        callSiteArray[25].call((Object)request, (Object)"search=bar&name=bucky");
        callSiteArray[26].call((Object)this.env, (Object)"control.uri", (Object)"http://destination");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].callConstructor(ProxyRequestContext.class, (Object)"control"), (Object)"http://destination/foo?search=bar&name=bucky"), ProxyRequestContext.class);
        callSiteArray[29].call(callSiteArray[30].callStatic(Mockito.class, callSiteArray[31].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[32].callStatic(Assert.class, (Object)result, callSiteArray[33].call((Object)this.proxy, (Object)"control", (Object)request));
    }

    @Test
    public void withQueryStringEncoding() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(ResponseEntity.class, callSiteArray[35].callConstructor(Object.class), callSiteArray[36].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[38].call((Object)request, (Object)"GET");
        callSiteArray[39].call((Object)request, callSiteArray[40].callGetProperty(HandlerMapping.class), (Object)"/control/foo");
        callSiteArray[41].call((Object)request, (Object)"search=bar&name=bucky%20badger");
        callSiteArray[42].call((Object)this.env, (Object)"control.uri", (Object)"http://destination");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(callSiteArray[44].callConstructor(ProxyRequestContext.class, (Object)"control"), (Object)"http://destination/foo?search=bar&name=bucky badger"), ProxyRequestContext.class);
        ProxyRequestContext notExpected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].call(callSiteArray[46].callConstructor(ProxyRequestContext.class, (Object)"control"), (Object)"http://destination/foo?search=bar&name=bucky%20badger"), ProxyRequestContext.class);
        callSiteArray[47].call(callSiteArray[48].callStatic(Mockito.class, callSiteArray[49].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[50].call(callSiteArray[51].callStatic(Mockito.class, callSiteArray[52].call((Object)this.proxyDao, (Object)notExpected)), null);
        callSiteArray[53].callStatic(Assert.class, (Object)result, callSiteArray[54].call((Object)this.proxy, (Object)"control", (Object)request));
    }

    @Test
    public void proxyRequest_failsWithBadRequest() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ValidationResult validationFailure = (ValidationResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(ValidationResult.class, (Object)false, (Object)"you didn't check the box"), ValidationResult.class);
        ResponseEntity expectedResult = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor(ResponseEntity.class, (Object)validationFailure, callSiteArray[57].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[59].call((Object)request, (Object)"POST");
        callSiteArray[60].call((Object)request, callSiteArray[61].callGetProperty(HandlerMapping.class), (Object)"/control/foo");
        callSiteArray[62].call((Object)request, callSiteArray[63].call((Object)"{ \"hello\": \"world\" }"));
        callSiteArray[64].call((Object)request, (Object)"Content-Type", (Object)"application/json");
        callSiteArray[65].call((Object)this.env, (Object)"control.uri", (Object)"http://destination");
        callSiteArray[66].call(callSiteArray[67].callStatic(Mockito.class, callSiteArray[68].call((Object)this.proxyDao, callSiteArray[69].callStatic(Mockito.class, ProxyRequestContext.class))), (Object)expectedResult);
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)this.proxy, (Object)"control", (Object)request), ResponseEntity.class);
        callSiteArray[71].callStatic(Assert.class, (Object)expectedResult, (Object)result);
        callSiteArray[72].callStatic(Assert.class, (Object)validationFailure, callSiteArray[73].call((Object)result));
    }

    @Test
    public void proxyRequest_withCredentials() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(ResponseEntity.class, callSiteArray[75].callConstructor(Object.class), callSiteArray[76].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[78].call((Object)request, (Object)"GET");
        callSiteArray[79].call((Object)this.env, (Object)"withCredentials.uri", (Object)"http://localhost/foo");
        callSiteArray[80].call((Object)this.env, (Object)"withCredentials.username", (Object)"user");
        callSiteArray[81].call((Object)this.env, (Object)"withCredentials.password", (Object)"pass");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].callConstructor(ProxyRequestContext.class, (Object)"withCredentials"), (Object)"http://localhost/foo"), (Object)"user"), (Object)"pass"), ProxyRequestContext.class);
        callSiteArray[86].call(callSiteArray[87].callStatic(Mockito.class, callSiteArray[88].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[89].callStatic(Assert.class, (Object)result, callSiteArray[90].call((Object)this.proxy, (Object)"withCredentials", (Object)request));
    }

    @Test
    public void proxyRequest_withAdditionalHeader() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(ResponseEntity.class, callSiteArray[92].callConstructor(Object.class), callSiteArray[93].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[95].call((Object)request, (Object)"wiscedupvi", (Object)"UW111A111");
        callSiteArray[96].call((Object)request, (Object)"GET");
        callSiteArray[97].call((Object)this.env, (Object)"withAdditionalHeaders.uri", (Object)"http://localhost/foo");
        callSiteArray[98].call((Object)this.env, (Object)"withAdditionalHeaders.proxyHeaders", (Object)"Some-Header: staticvalue");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].call(callSiteArray[100].callConstructor(ProxyRequestContext.class, (Object)"withAdditionalHeaders"), (Object)"http://localhost/foo"), ProxyRequestContext.class);
        callSiteArray[101].call(callSiteArray[102].call((Object)expected), (Object)"Some-Header", (Object)"staticvalue");
        callSiteArray[103].call(callSiteArray[104].callStatic(Mockito.class, callSiteArray[105].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[106].callStatic(Assert.class, (Object)result, callSiteArray[107].call((Object)this.proxy, (Object)"withAdditionalHeaders", (Object)request));
    }

    @Test
    public void proxyRequest_withAdditionalHeaders_andPlaceholders() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].callConstructor(ResponseEntity.class, callSiteArray[109].callConstructor(Object.class), callSiteArray[110].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[112].call((Object)request, (Object)"wiscedupvi", (Object)"UW111A111");
        callSiteArray[113].call((Object)request, (Object)"GET");
        callSiteArray[114].call((Object)this.env, (Object)"withAdditionalHeaders2.uri", (Object)"http://localhost/foo");
        callSiteArray[115].call((Object)this.env, (Object)"withAdditionalHeaders2.proxyHeaders", (Object)"On-Behalf-Of: {wiscedupvi}");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].call(callSiteArray[117].callConstructor(ProxyRequestContext.class, (Object)"withAdditionalHeaders2"), (Object)"http://localhost/foo"), ProxyRequestContext.class);
        callSiteArray[118].call(callSiteArray[119].call((Object)expected), (Object)"On-Behalf-Of", (Object)"UW111A111");
        callSiteArray[120].call(callSiteArray[121].callStatic(Mockito.class, callSiteArray[122].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[123].callStatic(Assert.class, (Object)result, callSiteArray[124].call((Object)this.proxy, (Object)"withAdditionalHeaders2", (Object)request));
    }

    @Test
    public void proxyRequest_withAdditionalPath() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].callConstructor(ResponseEntity.class, callSiteArray[126].callConstructor(Object.class), callSiteArray[127].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[129].call((Object)request, (Object)"GET");
        callSiteArray[130].call((Object)request, callSiteArray[131].callGetProperty(HandlerMapping.class), (Object)"api/v2/employee/123");
        callSiteArray[132].call((Object)this.env, (Object)"withAdditionalPath.uri", (Object)"http://localhost/foo");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call(callSiteArray[134].callConstructor(ProxyRequestContext.class, (Object)"withAdditionalPath"), (Object)"http://localhost/foo/api/v2/employee/123"), ProxyRequestContext.class);
        callSiteArray[135].call(callSiteArray[136].callStatic(Mockito.class, callSiteArray[137].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[138].callStatic(Assert.class, (Object)result, callSiteArray[139].call((Object)this.proxy, (Object)"withAdditionalPath", (Object)request));
    }

    @Test
    public void proxyRequest_withOutAdditionalPathResourceKeyIsSameAsResourcePath() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        ResponseEntity result = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callConstructor(ResponseEntity.class, callSiteArray[141].callConstructor(Object.class), callSiteArray[142].callGetProperty(HttpStatus.class)), ResponseEntity.class);
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[144].call((Object)request, (Object)"GET");
        callSiteArray[145].call((Object)request, callSiteArray[146].callGetProperty(HandlerMapping.class), (Object)"/withoutAdditionalHeaders");
        callSiteArray[147].call((Object)this.env, (Object)"withoutAdditionalHeaders.uri", (Object)"http://localhost/foo");
        ProxyRequestContext expected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].call(callSiteArray[149].callConstructor(ProxyRequestContext.class, (Object)"withoutAdditionalHeaders"), (Object)"http://localhost/foo"), ProxyRequestContext.class);
        ProxyRequestContext notExpected = (ProxyRequestContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].call(callSiteArray[151].callConstructor(ProxyRequestContext.class, (Object)"withoutAdditionalHeaders"), (Object)"http://localhost/foo/"), ProxyRequestContext.class);
        callSiteArray[152].call(callSiteArray[153].callStatic(Mockito.class, callSiteArray[154].call((Object)this.proxyDao, (Object)expected)), (Object)result);
        callSiteArray[155].call(callSiteArray[156].callStatic(Mockito.class, callSiteArray[157].call((Object)this.proxyDao, (Object)notExpected)), null);
        callSiteArray[158].callStatic(Assert.class, (Object)result, callSiteArray[159].call((Object)this.proxy, (Object)"withoutAdditionalHeaders", (Object)request));
    }

    @Test
    public void proxyRequest_withRequestBody() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[160].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[161].call((Object)request, (Object)"PUT");
        callSiteArray[162].call((Object)request, callSiteArray[163].callGetProperty(HandlerMapping.class), (Object)"/withRequestBody/foo");
        callSiteArray[164].call((Object)request, callSiteArray[165].call((Object)"{ \"hello\": \"world\" }"));
        callSiteArray[166].call((Object)request, (Object)"Content-Type", (Object)"application/json");
        callSiteArray[167].call((Object)this.env, (Object)"withRequestBody.uri", (Object)"http://destination");
        callSiteArray[168].call((Object)this.proxy, (Object)"withRequestBody", (Object)request);
        callSiteArray[169].call(callSiteArray[170].callStatic(Mockito.class, (Object)this.proxyDao), callSiteArray[171].callStatic(Mockito.class, ProxyRequestContext.class));
    }

    @Test
    public void proxyRequest_withRequestBody_notjson() {
        CallSite[] callSiteArray = RestProxyServiceImplTest.$getCallSiteArray();
        MockHttpServletRequest request = (MockHttpServletRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(MockHttpServletRequest.class), MockHttpServletRequest.class);
        callSiteArray[173].call((Object)request, (Object)"PUT");
        callSiteArray[174].call((Object)request, callSiteArray[175].callGetProperty(HandlerMapping.class), (Object)"/notjson/foo");
        callSiteArray[176].call((Object)request, callSiteArray[177].call((Object)"<html></html>"));
        callSiteArray[178].call((Object)request, (Object)"Content-Type", (Object)"text/html");
        callSiteArray[179].call((Object)this.env, (Object)"notjson.uri", (Object)"http://destination");
        callSiteArray[180].call((Object)this.proxy, (Object)"notjson", (Object)request);
        callSiteArray[181].call(callSiteArray[182].callStatic(Mockito.class, (Object)this.proxyDao), callSiteArray[183].callStatic(Mockito.class, ProxyRequestContext.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestProxyServiceImplTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "setEnv";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "OK";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "setMethod";
        stringArray[8] = "setAttribute";
        stringArray[9] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[10] = "setProperty";
        stringArray[11] = "setUri";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "thenReturn";
        stringArray[14] = "when";
        stringArray[15] = "proxyRequest";
        stringArray[16] = "assertEquals";
        stringArray[17] = "proxyRequest";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "OK";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "setMethod";
        stringArray[23] = "setAttribute";
        stringArray[24] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[25] = "setQueryString";
        stringArray[26] = "setProperty";
        stringArray[27] = "setUri";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "thenReturn";
        stringArray[30] = "when";
        stringArray[31] = "proxyRequest";
        stringArray[32] = "assertEquals";
        stringArray[33] = "proxyRequest";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "OK";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "setMethod";
        stringArray[39] = "setAttribute";
        stringArray[40] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[41] = "setQueryString";
        stringArray[42] = "setProperty";
        stringArray[43] = "setUri";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "setUri";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "thenReturn";
        stringArray[48] = "when";
        stringArray[49] = "proxyRequest";
        stringArray[50] = "thenReturn";
        stringArray[51] = "when";
        stringArray[52] = "proxyRequest";
        stringArray[53] = "assertEquals";
        stringArray[54] = "proxyRequest";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "BAD_REQUEST";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "setMethod";
        stringArray[60] = "setAttribute";
        stringArray[61] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[62] = "setContent";
        stringArray[63] = "getBytes";
        stringArray[64] = "addHeader";
        stringArray[65] = "setProperty";
        stringArray[66] = "thenReturn";
        stringArray[67] = "when";
        stringArray[68] = "proxyRequest";
        stringArray[69] = "any";
        stringArray[70] = "proxyRequest";
        stringArray[71] = "assertEquals";
        stringArray[72] = "assertEquals";
        stringArray[73] = "getBody";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "OK";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "setMethod";
        stringArray[79] = "setProperty";
        stringArray[80] = "setProperty";
        stringArray[81] = "setProperty";
        stringArray[82] = "setPassword";
        stringArray[83] = "setUsername";
        stringArray[84] = "setUri";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "thenReturn";
        stringArray[87] = "when";
        stringArray[88] = "proxyRequest";
        stringArray[89] = "assertEquals";
        stringArray[90] = "proxyRequest";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "OK";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "setAttribute";
        stringArray[96] = "setMethod";
        stringArray[97] = "setProperty";
        stringArray[98] = "setProperty";
        stringArray[99] = "setUri";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "put";
        stringArray[102] = "getHeaders";
        stringArray[103] = "thenReturn";
        stringArray[104] = "when";
        stringArray[105] = "proxyRequest";
        stringArray[106] = "assertEquals";
        stringArray[107] = "proxyRequest";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "OK";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "setAttribute";
        stringArray[113] = "setMethod";
        stringArray[114] = "setProperty";
        stringArray[115] = "setProperty";
        stringArray[116] = "setUri";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "put";
        stringArray[119] = "getHeaders";
        stringArray[120] = "thenReturn";
        stringArray[121] = "when";
        stringArray[122] = "proxyRequest";
        stringArray[123] = "assertEquals";
        stringArray[124] = "proxyRequest";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "OK";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "setMethod";
        stringArray[130] = "setAttribute";
        stringArray[131] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[132] = "setProperty";
        stringArray[133] = "setUri";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "thenReturn";
        stringArray[136] = "when";
        stringArray[137] = "proxyRequest";
        stringArray[138] = "assertEquals";
        stringArray[139] = "proxyRequest";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "OK";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "setMethod";
        stringArray[145] = "setAttribute";
        stringArray[146] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[147] = "setProperty";
        stringArray[148] = "setUri";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "setUri";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "thenReturn";
        stringArray[153] = "when";
        stringArray[154] = "proxyRequest";
        stringArray[155] = "thenReturn";
        stringArray[156] = "when";
        stringArray[157] = "proxyRequest";
        stringArray[158] = "assertEquals";
        stringArray[159] = "proxyRequest";
        stringArray[160] = "<$constructor$>";
        stringArray[161] = "setMethod";
        stringArray[162] = "setAttribute";
        stringArray[163] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[164] = "setContent";
        stringArray[165] = "getBytes";
        stringArray[166] = "addHeader";
        stringArray[167] = "setProperty";
        stringArray[168] = "proxyRequest";
        stringArray[169] = "proxyRequest";
        stringArray[170] = "verify";
        stringArray[171] = "any";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "setMethod";
        stringArray[174] = "setAttribute";
        stringArray[175] = "PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE";
        stringArray[176] = "setContent";
        stringArray[177] = "getBytes";
        stringArray[178] = "addHeader";
        stringArray[179] = "setProperty";
        stringArray[180] = "proxyRequest";
        stringArray[181] = "proxyRequest";
        stringArray[182] = "verify";
        stringArray[183] = "any";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[184];
        RestProxyServiceImplTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RestProxyServiceImplTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RestProxyServiceImplTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

