/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.restproxy.service;

import com.google.common.net.HttpHeaders;
import edu.wisc.my.restproxy.KeyUtils;
import edu.wisc.my.restproxy.dao.RestProxyDao;
import edu.wisc.my.restproxy.model.ProxyAuthMethod;
import edu.wisc.my.restproxy.model.ProxyRequestContext;
import edu.wisc.my.restproxy.model.RequestBody;
import edu.wisc.my.restproxy.service.RestProxyService;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.HandlerMapping;

@Service
public class RestProxyServiceImpl
implements RestProxyService,
GroovyObject {
    @Autowired
    private Environment env;
    @Autowired
    private RestProxyDao proxyDao;
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RestProxyServiceImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void setEnv(Environment env) {
        Environment environment;
        this.env = environment = env;
    }

    @Override
    public ResponseEntity<Object> proxyRequest(String resourceKey, HttpServletRequest request) {
        String resourceRoot = this.env.getProperty(StringGroovyMethods.plus((String)resourceKey, (CharSequence)".uri"));
        if (StringUtils.isBlank((CharSequence)resourceRoot)) {
            logger.info("unknown resourceKey {}", (Object)resourceKey);
            return (ResponseEntity)ScriptBytecodeAdapter.castToType(null, ResponseEntity.class);
        }
        StringBuilder uri = new StringBuilder(resourceRoot);
        String resourcePath = ShortTypeHandling.castToString((Object)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
            if (resourcePath.startsWith(StringGroovyMethods.plus((String)"/proxy/", (CharSequence)resourceKey))) {
                String string;
                resourcePath = string = resourcePath.replaceFirst(StringGroovyMethods.plus((String)"/proxy/", (CharSequence)resourceKey), "");
            }
            if (!StringUtils.endsWith((CharSequence)uri, (CharSequence)"/") && StringUtils.isNotBlank((CharSequence)resourcePath) && !resourcePath.startsWith("/")) {
                uri.append("/");
            }
            uri.append(resourcePath);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            uri.append("?");
            uri.append(URLDecoder.decode(request.getQueryString()));
        }
        String authType = this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".auth"})));
        ProxyAuthMethod am = DefaultTypeTransformation.booleanUnbox((Object)authType) ? ProxyAuthMethod.valueOf(authType) : ProxyAuthMethod.NONE;
        String username = this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".username"})));
        String password = this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".password"})));
        ProxyRequestContext context = new ProxyRequestContext(resourceKey).setAttributes(KeyUtils.getHeaders(this.env, request, resourceKey)).setHttpMethod(HttpMethod.valueOf((String)request.getMethod())).setPassword(password).setHeaders(KeyUtils.getProxyHeaders(this.env, resourceKey, request)).setUri(uri.toString()).setUsername(username).setAuthMethod(am);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)am), (Object)((Object)ProxyAuthMethod.JWT))) {
            context.getJwtDetails().setId(Long.toString(System.currentTimeMillis()));
            context.getJwtDetails().setGrantType(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.granttype"}))));
            context.getJwtDetails().setIssuer(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.issuer"}))));
            context.getJwtDetails().setSubject(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.subject"}))));
            context.getJwtDetails().setSecret(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.secret"}))));
            context.getJwtDetails().setTtl(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.ttl"}))));
            context.getJwtDetails().setTokenURL(this.env.getProperty(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceKey}, new String[]{"", ".jwt.tokenurl"}))));
        }
        RequestBody requestBody = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            String contentType = request.getContentType();
            int contentLength = request.getContentLength();
            if (inputStream != null && contentLength > 0) {
                RequestBody requestBody2;
                requestBody = requestBody2 = new RequestBody().setBody(FileCopyUtils.copyToByteArray((InputStream)inputStream));
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    requestBody.setContentType(contentType);
                }
                context.setRequestBody(requestBody).getHeaders().put((Object)HttpHeaders.CONTENT_TYPE, (Object)contentType);
            }
        }
        catch (IOException e) {
            logger.debug("caught IOException attempting to check request inputStream, no requestBody provided", (Throwable)e);
        }
        logger.debug("proxying request {}", (Object)context);
        return this.proxyDao.proxyRequest(context);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestProxyServiceImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        RestProxyServiceImpl.logger = logger = LoggerFactory.getLogger(RestProxyServiceImpl.class);
    }
}

