/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber;

import enterprises.iwakura.amber.AmberManifest;
import enterprises.iwakura.amber.BootstrapOptions;
import enterprises.iwakura.amber.ChecksumResult;
import enterprises.iwakura.amber.ChecksumType;
import enterprises.iwakura.amber.ChecksumValidator;
import enterprises.iwakura.amber.Dependency;
import enterprises.iwakura.amber.DependencyDownloader;
import enterprises.iwakura.amber.DownloadResult;
import enterprises.iwakura.amber.Logger;
import enterprises.iwakura.amber.ManifestLoader;
import enterprises.iwakura.amber.Repository;
import enterprises.iwakura.amber.RepositoryType;
import enterprises.iwakura.amber.StringDownloadResult;
import enterprises.iwakura.amber.impl.ChecksumValidatorImpl;
import enterprises.iwakura.amber.impl.ClassLoaderManifestLoader;
import enterprises.iwakura.amber.impl.ConsoleLogger;
import enterprises.iwakura.amber.impl.JarFileManifestLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class Amber {
    protected final ManifestLoader manifestLoader;
    protected final Map<RepositoryType, DependencyDownloader> downloaders;
    protected final ChecksumValidator checksumValidator;
    protected final Logger logger;

    public static Amber classLoader() {
        return Amber.classLoader(Thread.currentThread().getContextClassLoader());
    }

    public static Amber classLoader(ClassLoader classLoader) {
        return Amber.classLoader(classLoader, new ConsoleLogger(false));
    }

    public static Amber classLoader(ClassLoader classLoader, Logger logger) {
        return new Amber(new ClassLoaderManifestLoader(classLoader), DependencyDownloader.defaultDownloaders(), new ChecksumValidatorImpl(), logger);
    }

    public static Amber jarFiles(List<Path> jarFilePaths) {
        return Amber.jarFiles(jarFilePaths, new ConsoleLogger(false));
    }

    public static Amber jarFiles(List<Path> jarFilePaths, Logger logger) {
        return new Amber(new JarFileManifestLoader(jarFilePaths), DependencyDownloader.defaultDownloaders(), new ChecksumValidatorImpl(), logger);
    }

    public List<Path> bootstrap() throws IOException {
        return this.bootstrap(BootstrapOptions.builder().build());
    }

    public List<Path> bootstrap(BootstrapOptions options) throws IOException {
        this.logger.info("Bootstrapping...");
        long startTime = System.nanoTime();
        this.logger.debug("Loading manifests...");
        List<AmberManifest> manifests = this.manifestLoader.loadManifest();
        if (manifests.isEmpty()) {
            this.logger.info("No manifests found. Nothing to bootstrap.");
            return Collections.emptyList();
        }
        this.logger.debug(String.format("Loaded %d manifests.", manifests.size()));
        ArrayList<Path> allDependencies = new ArrayList<Path>();
        this.logger.debug(String.format("Processing %d manifests...", manifests.size()));
        for (AmberManifest manifest : manifests) {
            allDependencies.addAll(this.processManifest(manifest, options));
        }
        this.logger.info(String.format("Bootstrapping completed (took %d ms)", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
        if (options.getExitCodeAfterDownload() != null) {
            this.logger.info("Exiting with code " + options.getExitCodeAfterDownload() + " as per configuration.");
            System.exit(options.getExitCodeAfterDownload());
            return null;
        }
        return allDependencies;
    }

    protected List<Path> processManifest(AmberManifest manifest, BootstrapOptions options) throws IOException {
        ArrayList<Path> dependencyPaths = new ArrayList<Path>();
        this.logger.info(String.format("Bootstrapping %d dependencies from %d repositories into %s", manifest.getDependencies().size(), manifest.getRepositories().size(), options.getPrefferedLibraryDirectory(manifest).toAbsolutePath()));
        for (Dependency dependency : manifest.getDependencies()) {
            long startTime = System.nanoTime();
            if (this.isDependencyDownloaded(dependency, manifest, options)) {
                this.logger.debug("Dependency exists: " + dependency);
                dependencyPaths.add(options.getPrefferedLibraryDirectory(manifest).resolve(dependency.getFileName()));
                continue;
            }
            Path libraryDir = options.getPrefferedLibraryDirectory(manifest);
            Path tempJarPath = options.getTempDirectory().resolve(dependency.getFileName() + UUID.randomUUID() + ".part");
            Path jarPath = libraryDir.resolve(dependency.getFileName());
            Files.createDirectories(jarPath.getParent(), new FileAttribute[0]);
            Files.createDirectories(tempJarPath.getParent(), new FileAttribute[0]);
            HashMap<Repository, DownloadResult> dependencyDownloadResults = new HashMap<Repository, DownloadResult>();
            DownloadResult checksumDownloadResult = null;
            ChecksumResult checksumResult = ChecksumResult.NOT_FOUND;
            this.logger.debug(String.format("Downloading dependency %s from %d repositories...", dependency, manifest.getRepositories().size()));
            block1: for (Repository repository2 : manifest.getRepositories()) {
                DependencyDownloader downloader = this.downloaders.get((Object)repository2.getType());
                if (downloader == null) {
                    this.logger.error("No downloader found for repository type: " + (Object)((Object)repository2.getType()), null);
                    continue;
                }
                this.logger.debug(String.format("Attempting to download %s from %s (may not specify the exact version)", dependency, repository2.getJarDownloadPath(dependency, null)));
                DownloadResult result = downloader.downloadJar(dependency, repository2, tempJarPath);
                dependencyDownloadResults.put(repository2, result);
                if (!result.isSuccess()) {
                    this.logger.debug("Download failed: " + result.getErrorMessage());
                    continue;
                }
                if (options.isValidateChecksums()) {
                    this.logger.debug("Validating checksums for " + dependency);
                    for (ChecksumType checksumType : ChecksumType.values()) {
                        StringDownloadResult tempResult = downloader.downloadChecksum(dependency, repository2, checksumType);
                        if (tempResult.isSuccess()) {
                            checksumResult = this.checksumValidator.validate(checksumType, tempResult.getContent(), tempJarPath);
                            this.logger.debug("Checksum " + (Object)((Object)checksumType) + " validation result: " + (Object)((Object)checksumResult));
                            if (checksumResult == ChecksumResult.UNSUPPORTED) {
                                this.logger.error("Unsupported algorithm for checksum type: " + (Object)((Object)checksumType), null);
                                continue;
                            }
                            checksumDownloadResult = tempResult;
                            break block1;
                        }
                        this.logger.debug("Checksum download failed for type " + (Object)((Object)checksumType) + ": " + tempResult.getErrorMessage());
                        checksumDownloadResult = tempResult;
                    }
                    continue;
                }
                this.logger.debug("Skipping checksum validation for " + dependency + " as per configuration.");
                checksumResult = ChecksumResult.MATCH;
            }
            if (dependencyDownloadResults.values().stream().noneMatch(DownloadResult::isSuccess)) {
                this.logger.error(String.format("Could not find %s in repositories: ", dependency), null);
                manifest.getRepositories().forEach(repository -> {
                    String errorMessage = Optional.ofNullable((DownloadResult)dependencyDownloadResults.get(repository)).map(DownloadResult::getErrorMessage).orElse("N/A");
                    this.logger.error(String.format(" - %s: %s", repository.getUrl(), errorMessage), null);
                });
                if (options.isFailOnMissingDependency()) {
                    throw new IOException("Failed to download dependency: " + dependency);
                }
            }
            if (checksumResult != ChecksumResult.MATCH) {
                if (checksumDownloadResult != null) {
                    this.logger.error(String.format("Checksum validation failed for %s: %s with error %s", new Object[]{dependency, checksumResult, checksumDownloadResult.getErrorMessage()}), null);
                } else {
                    this.logger.error(String.format("Checksum validation failed for %s: %s", new Object[]{dependency, checksumResult}), null);
                }
                if (options.isFailOnInvalidChecksum()) {
                    throw new IOException("Invalid checksum for dependency: " + dependency);
                }
            }
            this.logger.debug(String.format("Moving downloaded dependency at %s to %s", tempJarPath, jarPath));
            Files.move(tempJarPath, jarPath, StandardCopyOption.REPLACE_EXISTING);
            this.logger.info(String.format("Downloaded dependency %s to %s (took %d ms)", dependency, jarPath, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
            dependencyPaths.add(jarPath);
        }
        return dependencyPaths;
    }

    protected boolean isDependencyDownloaded(Dependency dependency, AmberManifest manifest, BootstrapOptions options) {
        if (options.isForceRedownload()) {
            this.logger.debug("Skipping existence check for " + dependency + " as per configuration.");
            return false;
        }
        Path libraryDir = options.getPrefferedLibraryDirectory(manifest);
        Path jarPath = libraryDir.resolve(dependency.getFileName());
        this.logger.debug("Checking existence of " + jarPath);
        return Files.exists(jarPath, new LinkOption[0]);
    }

    @Generated
    public ManifestLoader getManifestLoader() {
        return this.manifestLoader;
    }

    @Generated
    public Map<RepositoryType, DependencyDownloader> getDownloaders() {
        return this.downloaders;
    }

    @Generated
    public ChecksumValidator getChecksumValidator() {
        return this.checksumValidator;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public Amber(ManifestLoader manifestLoader, Map<RepositoryType, DependencyDownloader> downloaders, ChecksumValidator checksumValidator, Logger logger) {
        this.manifestLoader = manifestLoader;
        this.downloaders = downloaders;
        this.checksumValidator = checksumValidator;
        this.logger = logger;
    }
}

