/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber;

import enterprises.iwakura.amber.ChecksumType;
import enterprises.iwakura.amber.Dependency;
import enterprises.iwakura.amber.RepositoryType;
import lombok.Generated;

public class Repository {
    private final RepositoryType type;
    private final String url;

    public String getDownloadPathDirectory(Dependency dependency) {
        boolean urlEndsWithSlash = this.url.endsWith("/");
        return String.format("%1$s%2$s%3$s/%4$s/%5$s/", this.url, urlEndsWithSlash ? "" : "/", dependency.getGroupIdAsPath(), dependency.getName(), dependency.getVersion());
    }

    public String getJarDownloadPath(Dependency dependency, String versionOverride) {
        return String.format("%s%s-%s.jar", this.getDownloadPathDirectory(dependency), dependency.getName(), versionOverride != null ? versionOverride : dependency.getVersion());
    }

    public String getChecksumDownloadPath(Dependency dependency, String versionOverride, ChecksumType checksumType) {
        return this.getJarDownloadPath(dependency, versionOverride) + "." + checksumType.getFileExtension();
    }

    @Generated
    public RepositoryType getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RepositoryType this$type = this.getType();
        RepositoryType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Repository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RepositoryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Repository(type=" + (Object)((Object)this.getType()) + ", url=" + this.getUrl() + ")";
    }

    @Generated
    public Repository(RepositoryType type, String url) {
        this.type = type;
        this.url = url;
    }
}

