/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.economysystem.api;

import enterprises.iwakura.economysystem.api.dto.AccountingTransactionDTO;
import enterprises.iwakura.economysystem.api.dto.BankingAccountDTO;
import enterprises.iwakura.economysystem.api.dto.BankingAccountTypeEnum;
import gol.economy.entity.AccountingTransactionEntity;
import gol.economy.entity.BankingAccountEntity;
import gol.economy.service.BankingService;
import gol.economy.utils.AsyncUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EconomySystemAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EconomySystemAPI.class);
    private final Plugin plugin;

    public EconomySystemAPI(Plugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(UUID fromEntity, BankingAccountTypeEnum fromEntityAccountType, UUID toEntity, BankingAccountTypeEnum toEntityAccountType, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync(() -> {
            log.info("Plugin {} is transferring {} from {}[{}] to {}[{}]", new Object[]{this.plugin.getName(), amount, fromEntity, fromEntityAccountType, toEntity, toEntityAccountType});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromEntity, fromEntityAccountType.toEntity(), toEntity, toEntityAccountType.toEntity(), amount, detail);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(Long fromAccountNumber, Long toAccountNumber, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync(() -> {
            log.info("Plugin {} is transferring {} from {} to {}", new Object[]{this.plugin.getName(), amount, fromAccountNumber, toAccountNumber});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromAccountNumber, toAccountNumber, amount, detail);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<List<BankingAccountDTO>> getAccounts(UUID entityId) {
        CompletableFuture<List<BankingAccountDTO>> completableFuture = new CompletableFuture<List<BankingAccountDTO>>();
        AsyncUtils.runAsync(() -> {
            List accounts = BankingService.INSTANCE.getAccountsForEntityId(entityId);
            completableFuture.complete(accounts.stream().map(BankingAccountDTO::fromEntity).toList());
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<BankingAccountDTO> getAccount(UUID entityId, BankingAccountTypeEnum accountType) {
        CompletableFuture<BankingAccountDTO> completableFuture = new CompletableFuture<BankingAccountDTO>();
        AsyncUtils.runAsync(() -> {
            BankingAccountEntity account = (BankingAccountEntity)BankingService.INSTANCE.getAccountForEntityId(entityId, accountType.toEntity()).orElseThrow();
            completableFuture.complete(BankingAccountDTO.fromEntity(account));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EconomySystemAPI)) {
            return false;
        }
        EconomySystemAPI other = (EconomySystemAPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Plugin this$plugin = this.getPlugin();
        Plugin other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EconomySystemAPI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Plugin $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EconomySystemAPI(plugin=" + String.valueOf(this.getPlugin()) + ")";
    }
}

