package enterprises.iwakura.economysystem.api.dto;

import gol.economy.entity.LoanEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.OffsetDateTime;

/**
 * Loan DTO
 */
@Data
public class LoanDTO {

    private Long id;
    private OffsetDateTime createdAt;
    private BankingAccountDTO account;
    private BigDecimal amount;
    private BigDecimal calculatedQ;
    private int numberOfPayments;
    private int numberOfPaidPayments;
    private int gameDayPeriod;
    private int gameDayProgression; // 0 = pays, 1 = 0. day
    private String name;

    /**
     * Creates a new LoanDTO from the given entity.
     *
     * @param entity The entity to convert
     *
     * @return A new instance of LoanDTO
     */
    public static LoanDTO fromEntity(LoanEntity entity) {
        if (entity == null) {
            return null;
        }

        LoanDTO dto = new LoanDTO();
        dto.id = entity.getId();
        dto.createdAt = entity.getCreatedAt();
        dto.account = BankingAccountDTO.fromEntity(entity.getAccount());
        dto.amount = entity.getAmount();
        dto.calculatedQ = entity.getCalculatedQ();
        dto.numberOfPayments = entity.getNumberOfPayments();
        dto.numberOfPaidPayments = entity.getNumberOfPaidPayments();
        dto.gameDayPeriod = entity.getGameDayPeriod();
        dto.gameDayProgression = entity.getGameDayProgression();
        dto.name = entity.getName();
        return dto;
    }

}
