/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.economysystem.api;

import enterprises.iwakura.economysystem.api.dto.AccountingTransactionDTO;
import enterprises.iwakura.economysystem.api.dto.BankingAccountDTO;
import enterprises.iwakura.economysystem.api.dto.BankingAccountTypeEnum;
import enterprises.iwakura.economysystem.api.dto.StandingOrderDTO;
import enterprises.iwakura.economysystem.api.events.AccountingTransactionEventDTO;
import gol.economy.entity.AccountingTransactionEntity;
import gol.economy.entity.BankingAccountEntity;
import gol.economy.entity.StandingOrderEntity;
import gol.economy.exception.EntityDoesNotExistException;
import gol.economy.listener.AccountingTransactionListener;
import gol.economy.service.BankingService;
import gol.economy.utils.AsyncUtils;
import gol.economy.utils.SentryIntegration;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EconomySystemAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EconomySystemAPI.class);
    private final Plugin plugin;

    public EconomySystemAPI(Plugin plugin) {
        this.plugin = plugin;
        AccountingTransactionListener.apiEventConsumer = event -> AsyncUtils.callEventAsync((Event)AccountingTransactionEventDTO.fromEntity(event));
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(UUID fromEntity, BankingAccountTypeEnum fromEntityAccountType, UUID toEntity, BankingAccountTypeEnum toEntityAccountType, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_transfer_1", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is transferring {} from {}[{}] to {}[{}]", new Object[]{this.plugin.getName(), amount, fromEntity, fromEntityAccountType, toEntity, toEntityAccountType});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromEntity, fromEntityAccountType.toEntity(), toEntity, toEntityAccountType.toEntity(), amount, detail, false);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(Long fromAccountNumber, Long toAccountNumber, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_transfer_2", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is transferring {} from {} to {}", new Object[]{this.plugin.getName(), amount, fromAccountNumber, toAccountNumber});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromAccountNumber, toAccountNumber, amount, detail, false);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(UUID fromEntity, BankingAccountTypeEnum fromEntityAccountType, UUID toEntity, BankingAccountTypeEnum toEntityAccountType, BigDecimal amount, String detail, boolean silent) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_transfer_3", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is transferring {} from {}[{}] to {}[{}]", new Object[]{this.plugin.getName(), amount, fromEntity, fromEntityAccountType, toEntity, toEntityAccountType});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromEntity, fromEntityAccountType.toEntity(), toEntity, toEntityAccountType.toEntity(), amount, detail, silent);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> transfer(Long fromAccountNumber, Long toAccountNumber, BigDecimal amount, String detail, boolean silent) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_transfer_4", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is transferring {} from {} to {}", new Object[]{this.plugin.getName(), amount, fromAccountNumber, toAccountNumber});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.transfer(fromAccountNumber, toAccountNumber, amount, detail, silent);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> withdraw(Long accountNumber, BigDecimal amount, String detail, boolean silent, boolean allowNegative) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_withdraw_1", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is withdrawing {} from {}", new Object[]{this.plugin.getName(), amount, accountNumber});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.withdrawBalance(accountNumber, amount, detail, silent, allowNegative);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> withdraw(UUID entity, BankingAccountTypeEnum type, BigDecimal amount, String detail, boolean silent, boolean allowNegative) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_withdraw_2", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is withdrawing {} from {}[{}]", new Object[]{this.plugin.getName(), amount, entity, type});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.withdrawBalance(entity, type.toEntity(), amount, detail, silent, allowNegative);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> deposit(Long accountNumber, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_deposit_1", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is depositing {} to {}", new Object[]{this.plugin.getName(), amount, accountNumber});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.depositBalance(accountNumber, amount, detail, false);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<AccountingTransactionDTO> deposit(UUID entity, BankingAccountTypeEnum type, BigDecimal amount, String detail) {
        CompletableFuture<AccountingTransactionDTO> completableFuture = new CompletableFuture<AccountingTransactionDTO>();
        AsyncUtils.runAsync((String)"external_plugin_deposit_2", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is depositing {} to {}[{}]", new Object[]{this.plugin.getName(), amount, entity, type});
            AccountingTransactionEntity transaction = BankingService.INSTANCE.depositBalance(entity, type.toEntity(), amount, detail, false);
            completableFuture.complete(AccountingTransactionDTO.fromEntity(transaction));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<List<BankingAccountDTO>> getAccounts(UUID entityId) {
        CompletableFuture<List<BankingAccountDTO>> completableFuture = new CompletableFuture<List<BankingAccountDTO>>();
        AsyncUtils.runAsync((String)"external_plugin_get_accounts", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            List accounts = BankingService.INSTANCE.getAccountsForEntityId(entityId);
            completableFuture.complete(accounts.stream().map(BankingAccountDTO::fromEntity).toList());
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<BankingAccountDTO> getAccount(UUID entityId, BankingAccountTypeEnum accountType) {
        CompletableFuture<BankingAccountDTO> completableFuture = new CompletableFuture<BankingAccountDTO>();
        AsyncUtils.runAsync((String)"external_plugin_get_account", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            BankingAccountEntity account = (BankingAccountEntity)BankingService.INSTANCE.getAccountForEntityId(entityId, accountType.toEntity()).orElseThrow(() -> new EntityDoesNotExistException("account", new Object[]{entityId, accountType}));
            completableFuture.complete(BankingAccountDTO.fromEntity(account));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<BankingAccountDTO> getInfiniteAccount(String name) {
        CompletableFuture<BankingAccountDTO> completableFuture = new CompletableFuture<BankingAccountDTO>();
        AsyncUtils.runAsync((String)"external_plugin_get_infinite_account", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is getting infinite account for name {}", (Object)this.plugin.getName(), (Object)name);
            BankingAccountEntity account = (BankingAccountEntity)BankingService.INSTANCE.getInfiniteAccount(name).orElseThrow(() -> new EntityDoesNotExistException("infinite account", new Object[]{name}));
            completableFuture.complete(BankingAccountDTO.fromEntity(account));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<StandingOrderDTO> createBasicStandingOrder(long fromAccountNumber, long toAccountNumber, BigDecimal amount, int gameDayPeriod, boolean fromAccountEntityMustBeOnline, @NonNull String note) {
        if (note == null) {
            throw new NullPointerException("note is marked non-null but is null");
        }
        CompletableFuture<StandingOrderDTO> completableFuture = new CompletableFuture<StandingOrderDTO>();
        AsyncUtils.runAsync((String)"external_plugin_create_basic_standing_order", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is creating a basic standing order from {} to {} every {} game days (must be online: {}) with note: {}", new Object[]{this.plugin.getName(), fromAccountNumber, toAccountNumber, gameDayPeriod, fromAccountEntityMustBeOnline, note});
            StandingOrderEntity standingOrder = BankingService.INSTANCE.createBasicStandingOrder(fromAccountNumber, toAccountNumber, amount, gameDayPeriod, fromAccountEntityMustBeOnline, note, false);
            completableFuture.complete(StandingOrderDTO.fromEntity(standingOrder));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<StandingOrderDTO> createBasicStandingOrder(UUID fromEntityUuid, BankingAccountTypeEnum fromEntityAccountType, UUID toEntityUuid, BankingAccountTypeEnum toEntityAccountType, BigDecimal amount, int gameDayPeriod, boolean fromAccountEntityMustBeOnline, @NonNull String note) {
        if (note == null) {
            throw new NullPointerException("note is marked non-null but is null");
        }
        CompletableFuture<StandingOrderDTO> completableFuture = new CompletableFuture<StandingOrderDTO>();
        AsyncUtils.runAsync((String)"external_plugin_create_basic_standing_order_2", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is creating a basic standing order from {}[{}] to {}[{}] every {} game days (must be online: {}) with note: {}", new Object[]{this.plugin.getName(), fromEntityUuid, fromEntityAccountType, toEntityUuid, toEntityAccountType, gameDayPeriod, fromAccountEntityMustBeOnline, note});
            StandingOrderEntity standingOrder = BankingService.INSTANCE.createBasicStandingOrder(fromEntityUuid, fromEntityAccountType.toEntity(), toEntityUuid, toEntityAccountType.toEntity(), amount, gameDayPeriod, fromAccountEntityMustBeOnline, note, false);
            completableFuture.complete(StandingOrderDTO.fromEntity(standingOrder));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<StandingOrderDTO> createUniqueStandingOrder(long fromAccountNumber, long toAccountNumber, BigDecimal amount, int gameDayPeriod, boolean fromAccountEntityMustBeOnline, @NonNull String uniqueNote, boolean silent) {
        if (uniqueNote == null) {
            throw new NullPointerException("uniqueNote is marked non-null but is null");
        }
        CompletableFuture<StandingOrderDTO> completableFuture = new CompletableFuture<StandingOrderDTO>();
        AsyncUtils.runAsync((String)"external_plugin_create_unique_standing_order", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is creating a unique standing order from {} to {} every {} game days (must be online: {}) with note: {}", new Object[]{this.plugin.getName(), fromAccountNumber, toAccountNumber, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote});
            StandingOrderEntity standingOrder = BankingService.INSTANCE.createUniqueStandingOrder(fromAccountNumber, toAccountNumber, amount, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote, silent);
            completableFuture.complete(StandingOrderDTO.fromEntity(standingOrder));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<StandingOrderDTO> createUniqueStandingOrder(UUID fromEntityUuid, BankingAccountTypeEnum fromEntityAccountType, UUID toEntityUuid, BankingAccountTypeEnum toEntityAccountType, BigDecimal amount, int gameDayPeriod, boolean fromAccountEntityMustBeOnline, @NonNull String uniqueNote, boolean silent) {
        if (uniqueNote == null) {
            throw new NullPointerException("uniqueNote is marked non-null but is null");
        }
        CompletableFuture<StandingOrderDTO> completableFuture = new CompletableFuture<StandingOrderDTO>();
        AsyncUtils.runAsync((String)"external_plugin_create_unique_standing_order_2", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is creating a unique standing order from {}[{}] to {}[{}] every {} game days (must be online: {}) with note: {}", new Object[]{this.plugin.getName(), fromEntityUuid, fromEntityAccountType, toEntityUuid, toEntityAccountType, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote});
            StandingOrderEntity standingOrder = BankingService.INSTANCE.createUniqueStandingOrder(fromEntityUuid, fromEntityAccountType.toEntity(), toEntityUuid, toEntityAccountType.toEntity(), amount, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote, silent);
            completableFuture.complete(StandingOrderDTO.fromEntity(standingOrder));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<StandingOrderDTO> createUniqueStandingOrder(UUID fromEntityUuid, BankingAccountTypeEnum fromEntityAccountType, String infiniteAccountName, BigDecimal amount, int gameDayPeriod, boolean fromAccountEntityMustBeOnline, @NonNull String uniqueNote, boolean silent) {
        if (uniqueNote == null) {
            throw new NullPointerException("uniqueNote is marked non-null but is null");
        }
        CompletableFuture<StandingOrderDTO> completableFuture = new CompletableFuture<StandingOrderDTO>();
        AsyncUtils.runAsync((String)"external_plugin_create_unique_standing_order_3", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is creating a unique standing order from {}[{}] to infinite account {} every {} game days (must be online: {}) with note: {}", new Object[]{this.plugin.getName(), fromEntityUuid, fromEntityAccountType, infiniteAccountName, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote});
            StandingOrderEntity standingOrder = BankingService.INSTANCE.createUniqueStandingOrder(fromEntityUuid, fromEntityAccountType.toEntity(), infiniteAccountName, amount, gameDayPeriod, fromAccountEntityMustBeOnline, uniqueNote, silent);
            completableFuture.complete(StandingOrderDTO.fromEntity(standingOrder));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<List<StandingOrderDTO>> getStandingOrders(long fromAccountNumber) {
        CompletableFuture<List<StandingOrderDTO>> completableFuture = new CompletableFuture<List<StandingOrderDTO>>();
        AsyncUtils.runAsync((String)"external_plugin_get_standing_order", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is getting standing orders from {}", (Object)this.plugin.getName(), (Object)fromAccountNumber);
            List standingOrders = BankingService.INSTANCE.getStandingOrders(fromAccountNumber);
            completableFuture.complete(standingOrders.stream().map(StandingOrderDTO::fromEntity).toList());
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<List<StandingOrderDTO>> getStandingOrders(long fromAccountNumber, long toAccountNumber, @NonNull String note) {
        if (note == null) {
            throw new NullPointerException("note is marked non-null but is null");
        }
        CompletableFuture<List<StandingOrderDTO>> completableFuture = new CompletableFuture<List<StandingOrderDTO>>();
        AsyncUtils.runAsync((String)"external_plugin_get_standing_order", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is getting standing orders from {} to {} with note: {}", new Object[]{this.plugin.getName(), fromAccountNumber, toAccountNumber, note});
            List standingOrders = BankingService.INSTANCE.getStandingOrders(fromAccountNumber, toAccountNumber, note);
            completableFuture.complete(standingOrders.stream().map(StandingOrderDTO::fromEntity).toList());
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    public CompletableFuture<Void> removeStandingOrderById(long standingOrderId) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AsyncUtils.runAsync((String)"external_plugin_remove_standing_order", () -> {
            SentryIntegration.setSpanData((String)"external_plugin", (Object)this.plugin.getName());
            log.debug("Plugin {} is removing standing order with ID: {}", (Object)this.plugin.getName(), (Object)standingOrderId);
            BankingService.INSTANCE.removeStandingOrderById(standingOrderId);
            completableFuture.complete(null);
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EconomySystemAPI)) {
            return false;
        }
        EconomySystemAPI other = (EconomySystemAPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Plugin this$plugin = this.getPlugin();
        Plugin other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EconomySystemAPI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Plugin $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EconomySystemAPI(plugin=" + String.valueOf(this.getPlugin()) + ")";
    }
}

