package enterprises.iwakura.economysystem.api.dto;

import gol.economy.entity.BankingAccountEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.UUID;

/**
 * Banking account DTO
 */
@Data
public class BankingAccountDTO {

    private Long id;
    private OffsetDateTime createdAt;
    private UUID assignedToEntityId;
    private Long accountNumber;
    private BankingAccountTypeEnum accountType;
    private String name;
    private BigDecimal balance;

    /**
     * Creates a new BankingAccountDTO from the given entity.
     *
     * @param entity The entity to convert
     *
     * @return A new instance of BankingAccountDTO
     */
    public static BankingAccountDTO fromEntity(BankingAccountEntity entity) {
        if (entity == null) {
            return null;
        }

        BankingAccountDTO dto = new BankingAccountDTO();
        dto.id = entity.getId();
        dto.createdAt = entity.getCreatedAt();
        dto.assignedToEntityId = entity.getAssignedToEntityId();
        dto.accountNumber = entity.getAccountNumber();
        dto.accountType = BankingAccountTypeEnum.fromEntity(entity.getAccountType());
        dto.name = entity.getName();
        dto.balance = entity.getBalance();
        return dto;
    }
}
