package enterprises.iwakura.economysystem.api.dto;

import gol.economy.enums.BankingAccountType;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * Enum representing different types of banking accounts.
 */
@Getter
@RequiredArgsConstructor
public enum BankingAccountTypeEnum {
    CURRENT("Běžný účet"),
    SAVINGS("Spořící účet");

    private final String displayName;

    /**
     * Creates a new BankingAccountTypeEnum from the given entity.
     *
     * @param entityEnum The entity to convert
     *
     * @return A new instance of BankingAccountTypeEnum
     */
    public static BankingAccountTypeEnum fromEntity(BankingAccountType entityEnum) {
        if (entityEnum == null) {
            return null;
        }
        for (BankingAccountTypeEnum type : values()) {
            if (type.name().equals(entityEnum.name())) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown BankingAccountType: " + entityEnum);
    }

    /**
     * Converts this enum to its corresponding entity.
     *
     * @return The corresponding BankingAccountType entity
     */
    public BankingAccountType toEntity() {
        return BankingAccountType.valueOf(this.name());
    }
}
