package enterprises.iwakura.economysystem.api.dto;

import gol.economy.entity.StandingOrderEntity;
import lombok.Data;

/**
 * Standing Order DTO
 */
@Data
public class StandingOrderDTO {

    private Long id;
    private String createdAt;
    private BankingAccountDTO fromAccount;
    private BankingAccountDTO toAccount;
    private String amount;
    private int gameDayPeriod;
    private int gameDayProgression;
    private boolean fromAccountEntityMustBeOnline;
    private String note;

    /**
     * Creates a new StandingOrderDTO from the given entity.
     *
     * @param entity The entity to convert
     *
     * @return A new instance of StandingOrderDTO
     */
    public static StandingOrderDTO fromEntity(StandingOrderEntity entity) {
        if (entity == null) {
            return null;
        }

        StandingOrderDTO dto = new StandingOrderDTO();
        dto.id = entity.getId();
        dto.createdAt = entity.getCreatedAt().toString();
        dto.fromAccount = BankingAccountDTO.fromEntity(entity.getFromAccount());
        dto.toAccount = BankingAccountDTO.fromEntity(entity.getToAccount());
        dto.amount = entity.getAmount().toString();
        dto.gameDayPeriod = entity.getGameDayPeriod();
        dto.gameDayProgression = entity.getGameDayProgression();
        dto.fromAccountEntityMustBeOnline = entity.isFromAccountEntityMustBeOnline();
        dto.note = entity.getNote();
        return dto;
    }
}
