package enterprises.iwakura.economysystem.api.dto;

import gol.economy.entity.AccountingTransactionEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.OffsetDateTime;

/**
 * Accounting transaction DTO
 */
@Data
public class AccountingTransactionDTO {

    private Long id;
    private OffsetDateTime createdAt;
    private BankingAccountDTO fromAccount;
    private BankingAccountDTO toAccount;
    private BigDecimal amount;
    private String detail;
    private String verboseDetail;

    /**
     * Creates a new AccountingTransactionDTO from the given entity.
     *
     * @param entity The entity to convert
     *
     * @return A new instance of AccountingTransactionDTO
     */
    public static AccountingTransactionDTO fromEntity(AccountingTransactionEntity entity) {
        if (entity == null) {
            return null;
        }

        AccountingTransactionDTO dto = new AccountingTransactionDTO();
        dto.id = entity.getId();
        dto.createdAt = entity.getCreatedAt();
        dto.fromAccount = BankingAccountDTO.fromEntity(entity.getFromAccount());
        dto.toAccount = BankingAccountDTO.fromEntity(entity.getToAccount());
        dto.amount = entity.getAmount();
        dto.detail = entity.getDetail();
        dto.verboseDetail = entity.getVerboseDetail();
        return dto;
    }
}
