/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.amber.impl;

import enterprises.iwakura.amber.ChecksumResult;
import enterprises.iwakura.amber.ChecksumType;
import enterprises.iwakura.amber.ChecksumValidator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumValidatorImpl
implements ChecksumValidator {
    @Override
    public ChecksumResult validate(ChecksumType checksumType, String checksum, Path file) throws IOException {
        try {
            String fileChecksum = this.calculateChecksum(checksumType, file);
            if (fileChecksum.equalsIgnoreCase(checksum)) {
                return ChecksumResult.MATCH;
            }
            return ChecksumResult.MISMATCH;
        }
        catch (NoSuchAlgorithmException exception) {
            return ChecksumResult.UNSUPPORTED;
        }
    }

    protected String calculateChecksum(ChecksumType checksumType, Path file) throws IOException, NoSuchAlgorithmException {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance(checksumType.name());
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] hash = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                hexString.append(String.format("%02x", b));
            }
            String string = hexString.toString();
            return string;
        }
    }
}

