/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.concurrent;

import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.base.ModuleTask;
import enterprises.iwakura.modularbot.concurrent.ModuleRunnable;
import enterprises.iwakura.modularbot.concurrent.ModuleTaskTimer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import lombok.Generated;
import lombok.NonNull;

public final class ModuleScheduler {
    public static final String THREAD_NAME_FORMAT = ModuleScheduler.class.getSimpleName() + "-Task-%s";
    private final Executor taskExecutor = Executors.newCachedThreadPool();
    private final Module module;
    private final Map<ModuleTask, Thread> tasks = Collections.synchronizedMap(new HashMap());
    private final ModuleTaskTimer taskTimer;

    public ModuleScheduler(@NonNull Module module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        this.module = module;
        this.taskTimer = this.createTimer();
    }

    public void runAsync(Runnable runnable) {
        this.runTask(ModuleRunnable.create(this.module, runnable));
    }

    public void schedule(final Runnable runnable, long delay, long period) {
        this.taskTimer.getInstance().schedule(new TimerTask(this){

            @Override
            public void run() {
                runnable.run();
            }
        }, delay, period);
    }

    public void schedule(final Runnable runnable, long delay) {
        this.taskTimer.getInstance().schedule(new TimerTask(this){

            @Override
            public void run() {
                runnable.run();
            }
        }, delay);
    }

    public void scheduleFixed(final Runnable runnable, long delay, long period) {
        this.taskTimer.getInstance().scheduleAtFixedRate(new TimerTask(this){

            @Override
            public void run() {
                runnable.run();
            }
        }, delay, period);
    }

    private ModuleTaskTimer createTimer() {
        ModuleTaskTimer moduleTaskTimer = ModuleTaskTimer.create(this.module);
        this.runTask(moduleTaskTimer);
        return moduleTaskTimer;
    }

    private void runTask(ModuleTask moduleTask) {
        if (moduleTask instanceof ModuleRunnable) {
            this.taskExecutor.execute(() -> {
                Thread.currentThread().setName(THREAD_NAME_FORMAT.formatted(moduleTask.getUUID()));
                this.tasks.put(moduleTask, Thread.currentThread());
                moduleTask.start();
                this.tasks.remove(moduleTask);
            });
            return;
        }
        if (moduleTask instanceof ModuleTaskTimer) {
            this.tasks.put(moduleTask, null);
        }
    }

    public void cancelTasks() {
        HashMap<ModuleTask, Thread> tasksCopy = new HashMap<ModuleTask, Thread>(this.tasks);
        tasksCopy.forEach((moduleTask, thread) -> {
            try {
                moduleTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.tasks.clear();
    }

    public void removeTask(ModuleTask moduleTask) {
        this.tasks.remove(moduleTask);
    }

    @Generated
    public Module getModule() {
        return this.module;
    }
}

