/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.concurrent;

import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.base.ModuleTask;
import enterprises.iwakura.modularbot.concurrent.ModuleScheduler;
import java.util.Timer;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

public final class ModuleTaskTimer
implements ModuleTask {
    private final UUID uuid = UUID.randomUUID();
    private final Module owner;
    private final Timer instance = new Timer(ModuleScheduler.THREAD_NAME_FORMAT.formatted(this.uuid));
    private boolean running;
    private boolean cancelled;

    private ModuleTaskTimer(@NonNull Module owner) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        this.owner = owner;
    }

    static ModuleTaskTimer create(Module owner) {
        return new ModuleTaskTimer(owner);
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Module getOwner() {
        return this.owner;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void cancel() {
        this.instance.cancel();
        this.instance.purge();
        this.running = false;
        this.cancelled = true;
        this.owner.getModuleScheduler().removeTask(this);
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Generated
    public Timer getInstance() {
        return this.instance;
    }
}

