/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.config;

import dev.mayuna.pumpk1n.api.StorageHandler;
import enterprises.iwakura.modularbot.config.storage.FolderStorageSettings;
import enterprises.iwakura.modularbot.config.storage.SqlStorageSettings;
import enterprises.iwakura.modularbot.config.storage.SqliteStorageSettings;
import enterprises.iwakura.modularbot.config.storage.StorageLogLevelSettings;
import enterprises.iwakura.modularbot.config.storage.StorageTypeSettings;
import lombok.Generated;

public final class StorageSettings {
    private StorageLogLevelSettings logLevel = StorageLogLevelSettings.DEBUG;
    private boolean logOperations = false;
    private StorageTypeSettings storageType = StorageTypeSettings.SQL_LITE;
    private FolderStorageSettings folderStorageSettings;
    private SqliteStorageSettings sqliteStorageSettings;
    private SqlStorageSettings sqlStorageSettings;

    @Deprecated
    public StorageSettings() {
        this("default");
    }

    public StorageSettings(String defaultStorageName) {
        this.folderStorageSettings = new FolderStorageSettings(defaultStorageName);
        this.sqliteStorageSettings = new SqliteStorageSettings(defaultStorageName);
        this.sqlStorageSettings = new SqlStorageSettings(defaultStorageName);
    }

    public StorageHandler createStorageHandler() {
        return switch (this.storageType) {
            default -> throw new MatchException(null, null);
            case StorageTypeSettings.FOLDER -> this.folderStorageSettings.createStorageHandler();
            case StorageTypeSettings.SQL_LITE -> this.sqliteStorageSettings.createStorageHandler();
            case StorageTypeSettings.SQL -> this.sqlStorageSettings.createStorageHandler();
        };
    }

    @Generated
    public StorageLogLevelSettings getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public boolean isLogOperations() {
        return this.logOperations;
    }

    @Generated
    public StorageTypeSettings getStorageType() {
        return this.storageType;
    }

    @Generated
    public FolderStorageSettings getFolderStorageSettings() {
        return this.folderStorageSettings;
    }

    @Generated
    public SqliteStorageSettings getSqliteStorageSettings() {
        return this.sqliteStorageSettings;
    }

    @Generated
    public SqlStorageSettings getSqlStorageSettings() {
        return this.sqlStorageSettings;
    }
}

