/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.concurrent;

import enterprises.iwakura.modularbot.base.Module;
import enterprises.iwakura.modularbot.base.ModuleTask;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

public final class ModuleRunnable
implements ModuleTask {
    private final UUID uuid = UUID.randomUUID();
    private final Module owner;
    private final Runnable runnable;
    private boolean running;
    private boolean ran;

    private ModuleRunnable(@NonNull Module owner, @NonNull Runnable runnable) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.owner = owner;
        this.runnable = runnable;
    }

    static ModuleRunnable create(@NonNull Module owner, @NonNull Runnable runnable) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return new ModuleRunnable(owner, runnable);
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void cancel() {
        this.owner.getModuleScheduler().removeTask(this);
    }

    @Override
    public void start() {
        this.running = true;
        this.runnable.run();
        this.running = false;
        this.ran = true;
        this.cancel();
    }

    @Override
    @Generated
    public Module getOwner() {
        return this.owner;
    }

    @Generated
    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    @Generated
    public boolean isRunning() {
        return this.running;
    }

    @Generated
    public boolean isRan() {
        return this.ran;
    }
}

