/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.modularbot.managers;

import dev.mayuna.pumpk1n.Pumpk1n;
import dev.mayuna.pumpk1n.objects.DataHolder;
import dev.mayuna.pumpk1n.util.BaseLogger;
import enterprises.iwakura.modularbot.config.StorageSettings;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModularBotDataManager
extends Pumpk1n {
    @Generated
    private static final Logger log = LogManager.getLogger(ModularBotDataManager.class);
    public static final UUID GLOBAL_DATA_HOLDER_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final StorageSettings storageSettings;

    public ModularBotDataManager(StorageSettings storageSettings) {
        super(storageSettings.createStorageHandler());
        this.storageSettings = storageSettings;
        this.createLogger();
        this.getLogger().log("Using StorageHandler: " + this.storageHandler.getName());
    }

    private void createLogger() {
        this.setLogger(new BaseLogger(){

            public void log(@NonNull String message, Throwable throwable) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
                if (throwable == null) {
                    log.log(ModularBotDataManager.this.storageSettings.getLogLevel().getLog4jLevel(), message);
                } else {
                    log.log(ModularBotDataManager.this.storageSettings.getLogLevel().getLog4jLevel(), message, throwable);
                }
            }
        });
    }

    @NonNull
    public DataHolder getOrCreateDataHolder(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (uuid == GLOBAL_DATA_HOLDER_UUID) {
            throw new IllegalArgumentException("This UUID is reserved for Global Data Holder!");
        }
        return super.getOrCreateDataHolder(uuid);
    }

    @NonNull
    public DataHolder getGlobalDataHolder() {
        return super.getOrCreateDataHolder(GLOBAL_DATA_HOLDER_UUID);
    }
}

